/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.Arrays;
import java.util.List;
import org.apache.asterix.metadata.bootstrap.MetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public final class DatatypeEntity {
    private static final DatatypeEntity DATATYPE = new DatatypeEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_DATATYPE, 3, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DataverseName"), List.of("DatatypeName")), 0, DatatypeEntity.datatypeType(), true, new int[]{0, 1}), 2, -1);
    private static final DatatypeEntity DB_DATATYPE = new DatatypeEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_DATATYPE, 4, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DatabaseName"), List.of("DataverseName"), List.of("DatatypeName")), 0, DatatypeEntity.databaseDatatypeType(), true, new int[]{0, 1, 2}), 3, 0);
    private final int payloadPosition;
    private final MetadataIndex index;
    private final int databaseNameIndex;
    private final int dataverseNameIndex;
    private final int datatypeNameIndex;
    private final int derivedIndex;
    private final int timestampIndex;

    private DatatypeEntity(MetadataIndex index, int payloadPosition, int startIndex) {
        this.index = index;
        this.payloadPosition = payloadPosition;
        this.databaseNameIndex = startIndex++;
        this.dataverseNameIndex = startIndex++;
        this.datatypeNameIndex = startIndex++;
        this.derivedIndex = startIndex++;
        this.timestampIndex = startIndex++;
    }

    public static DatatypeEntity of(boolean usingDatabase) {
        return usingDatabase ? DB_DATATYPE : DATATYPE;
    }

    public MetadataIndex getIndex() {
        return this.index;
    }

    public ARecordType getRecordType() {
        return this.index.getPayloadRecordType();
    }

    public int payloadPosition() {
        return this.payloadPosition;
    }

    public int databaseNameIndex() {
        return this.databaseNameIndex;
    }

    public int dataverseNameIndex() {
        return this.dataverseNameIndex;
    }

    public int datatypeNameIndex() {
        return this.datatypeNameIndex;
    }

    public int derivedIndex() {
        return this.derivedIndex;
    }

    public int timestampIndex() {
        return this.timestampIndex;
    }

    private static ARecordType datatypeType() {
        return MetadataRecordTypes.createRecordType("DatatypeRecordType", new String[]{"DataverseName", "DatatypeName", "Derived", "Timestamp"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, AUnionType.createUnknownableType((IAType)MetadataRecordTypes.DERIVEDTYPE_RECORDTYPE), BuiltinType.ASTRING}, true);
    }

    private static ARecordType databaseDatatypeType() {
        return MetadataRecordTypes.createRecordType("DatatypeRecordType", new String[]{"DatabaseName", "DataverseName", "DatatypeName", "Derived", "Timestamp"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, AUnionType.createUnknownableType((IAType)MetadataRecordTypes.DERIVEDTYPE_RECORDTYPE), BuiltinType.ASTRING}, true);
    }
}

