/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.expressions;

import java.util.Objects;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;

public class HashJoinExpressionAnnotation
implements IExpressionAnnotation {
    private BuildOrProbe buildOrProbe;
    private String name;
    private BuildSide side;

    public HashJoinExpressionAnnotation(Pair<BuildOrProbe, String> pair) {
        this.buildOrProbe = Objects.requireNonNull((BuildOrProbe)((Object)pair.getFirst()));
        this.name = this.validateName((String)pair.getSecond());
        this.side = null;
    }

    public HashJoinExpressionAnnotation(BuildSide side) {
        this.buildOrProbe = null;
        this.name = null;
        this.side = Objects.requireNonNull(side);
    }

    public BuildOrProbe getBuildOrProbe() {
        return this.buildOrProbe;
    }

    public String getName() {
        return this.name;
    }

    public BuildSide getBuildSide() {
        return this.side;
    }

    public void setBuildSide(BuildSide side) {
        this.buildOrProbe = null;
        this.name = null;
        this.side = Objects.requireNonNull(side);
    }

    private String validateName(String name) {
        String n = Objects.requireNonNull(name);
        if (n.isBlank()) {
            throw new IllegalArgumentException("HashJoinExpressionAnnotation:" + name + "cannot be blank");
        }
        return n;
    }

    public static enum BuildOrProbe {
        BUILD,
        PROBE;

    }

    public static enum BuildSide {
        LEFT,
        RIGHT;

    }
}

