/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter.types;

import java.util.Collection;
import java.util.Deque;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import tech.allegro.schema.json2avro.converter.JsonToAvroReader;
import tech.allegro.schema.json2avro.converter.types.AvroTypeConverterWithStrictJavaTypeCheck;

public class ArrayConverter
extends AvroTypeConverterWithStrictJavaTypeCheck<Collection> {
    private final JsonToAvroReader jsonToAvroReader;

    public ArrayConverter(JsonToAvroReader jsonToAvroReader) {
        super(Collection.class);
        this.jsonToAvroReader = jsonToAvroReader;
    }

    @Override
    public Object convertValue(Schema.Field field, Schema schema, Collection value, Deque<String> path, boolean silently) {
        return value.stream().map(item -> this.jsonToAvroReader.read(field, schema.getElementType(), item, path, false)).collect(Collectors.toList());
    }

    @Override
    public boolean canManage(Schema schema, Deque<String> path) {
        return schema.getType().equals((Object)Schema.Type.ARRAY);
    }
}

