/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.filter.range.accessor;

import java.util.Set;
import org.apache.asterix.column.filter.FilterAccessorProvider;
import org.apache.asterix.column.filter.range.IColumnRangeFilterValueAccessor;
import org.apache.asterix.column.filter.range.IColumnRangeFilterValueAccessorFactory;
import org.apache.asterix.column.filter.range.accessor.ConstantColumnRangeFilterValueAccessor;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ConstantColumnRangeFilterValueAccessorFactory
implements IColumnRangeFilterValueAccessorFactory {
    private static final long serialVersionUID = -4835407779342615453L;
    public static final Set<ATypeTag> SUPPORTED_CONSTANT_TYPES = Set.of(ATypeTag.BOOLEAN, ATypeTag.BIGINT, ATypeTag.DOUBLE, ATypeTag.STRING);
    private final long normalizedValue;
    private final ATypeTag typeTag;
    private final String stringValue;

    private ConstantColumnRangeFilterValueAccessorFactory(String stringValue, long normalizedValue, ATypeTag typeTag) {
        this.stringValue = stringValue;
        this.normalizedValue = normalizedValue;
        this.typeTag = typeTag;
    }

    public static ConstantColumnRangeFilterValueAccessorFactory createFactory(IAObject value) {
        long normalizedValue;
        String stringValue;
        ATypeTag typeTag = value.getType().getTypeTag();
        switch (typeTag) {
            case BOOLEAN: {
                boolean booleanVal = ((ABoolean)value).getBoolean();
                stringValue = Boolean.toString(booleanVal);
                normalizedValue = booleanVal ? 1L : 0L;
                break;
            }
            case BIGINT: {
                long longVal = ((AInt64)value).getLongValue();
                stringValue = Long.toString(longVal);
                normalizedValue = longVal;
                break;
            }
            case DOUBLE: {
                double doubleVal = ((ADouble)value).getDoubleValue();
                stringValue = Double.toString(doubleVal);
                normalizedValue = Double.doubleToLongBits(doubleVal);
                break;
            }
            case STRING: {
                stringValue = ((AString)value).getStringValue();
                normalizedValue = ConstantColumnRangeFilterValueAccessorFactory.normalize(stringValue);
                break;
            }
            default: {
                return null;
            }
        }
        return new ConstantColumnRangeFilterValueAccessorFactory(stringValue, normalizedValue, typeTag);
    }

    @Override
    public IColumnRangeFilterValueAccessor create(FilterAccessorProvider filterAccessorProvider) throws HyracksDataException {
        return new ConstantColumnRangeFilterValueAccessor(this.normalizedValue, this.typeTag);
    }

    public String toString() {
        if (this.typeTag == ATypeTag.STRING) {
            return "\"" + this.stringValue + "\"";
        }
        return this.stringValue;
    }

    private static long normalize(String value) {
        long nk = 0L;
        for (int i = 0; i < 4; ++i) {
            nk <<= 16;
            if (i >= value.length()) continue;
            nk += (long)(value.charAt(i) & 0xFFFF);
        }
        return nk >>> 1;
    }
}

