/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.parquet.ParquetConversions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.BinaryUtil;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;

public class ParquetMetricsRowGroupFilter {
    private static final int IN_PREDICATE_LIMIT = 200;
    private final Schema schema;
    private final Expression expr;
    private static final boolean ROWS_MIGHT_MATCH = true;
    private static final boolean ROWS_CANNOT_MATCH = false;

    public ParquetMetricsRowGroupFilter(Schema schema, Expression unbound) {
        this(schema, unbound, true);
    }

    public ParquetMetricsRowGroupFilter(Schema schema, Expression unbound, boolean caseSensitive) {
        this.schema = schema;
        Types.StructType struct = schema.asStruct();
        this.expr = Binder.bind((Types.StructType)struct, (Expression)Expressions.rewriteNot((Expression)unbound), (boolean)caseSensitive);
    }

    public boolean shouldRead(MessageType fileSchema, BlockMetaData rowGroup) {
        return new MetricsEvalVisitor().eval(fileSchema, rowGroup);
    }

    static boolean hasNonNullButNoMinMax(Statistics statistics, long valueCount) {
        return statistics.getNumNulls() < valueCount && (statistics.getMaxBytes() == null || statistics.getMinBytes() == null);
    }

    private static boolean mayContainNull(Statistics statistics) {
        return !statistics.isNumNullsSet() || statistics.getNumNulls() > 0L;
    }

    private class MetricsEvalVisitor
    extends ExpressionVisitors.BoundExpressionVisitor<Boolean> {
        private Map<Integer, Statistics<?>> stats = null;
        private Map<Integer, Long> valueCounts = null;
        private Map<Integer, Function<Object, Object>> conversions = null;

        private MetricsEvalVisitor() {
        }

        private boolean eval(MessageType fileSchema, BlockMetaData rowGroup) {
            if (rowGroup.getRowCount() <= 0L) {
                return false;
            }
            this.stats = Maps.newHashMap();
            this.valueCounts = Maps.newHashMap();
            this.conversions = Maps.newHashMap();
            for (ColumnChunkMetaData col : rowGroup.getColumns()) {
                PrimitiveType colType = fileSchema.getType(col.getPath().toArray()).asPrimitiveType();
                if (colType.getId() == null) continue;
                int id = colType.getId().intValue();
                Type icebergType = ParquetMetricsRowGroupFilter.this.schema.findType(id);
                this.stats.put(id, col.getStatistics());
                this.valueCounts.put(id, col.getValueCount());
                this.conversions.put(id, ParquetConversions.converterFromParquet(colType, icebergType));
            }
            return ExpressionVisitors.visitEvaluator((Expression)ParquetMetricsRowGroupFilter.this.expr, (ExpressionVisitors.ExpressionVisitor)this);
        }

        public Boolean alwaysTrue() {
            return true;
        }

        public Boolean alwaysFalse() {
            return false;
        }

        public Boolean not(Boolean result) {
            return result == false;
        }

        public Boolean and(Boolean leftResult, Boolean rightResult) {
            return leftResult != false && rightResult != false;
        }

        public Boolean or(Boolean leftResult, Boolean rightResult) {
            return leftResult != false || rightResult != false;
        }

        public <T> Boolean isNull(BoundReference<T> ref) {
            int id = ref.fieldId();
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return true;
            }
            Statistics<?> colStats = this.stats.get(id);
            if (colStats != null && !colStats.isEmpty() && colStats.getNumNulls() == 0L) {
                return false;
            }
            return true;
        }

        public <T> Boolean notNull(BoundReference<T> ref) {
            int id = ref.fieldId();
            if (ParquetMetricsRowGroupFilter.this.schema.findType(id) instanceof Type.NestedType) {
                return true;
            }
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return false;
            }
            Statistics<?> colStats = this.stats.get(id);
            if (colStats != null && valueCount - colStats.getNumNulls() == 0L) {
                return false;
            }
            return true;
        }

        public <T> Boolean isNaN(BoundReference<T> ref) {
            int id = ref.fieldId();
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return false;
            }
            Statistics<?> colStats = this.stats.get(id);
            if (colStats != null && valueCount - colStats.getNumNulls() == 0L) {
                return false;
            }
            return true;
        }

        public <T> Boolean notNaN(BoundReference<T> ref) {
            return true;
        }

        public <T> Boolean lt(BoundReference<T> ref, Literal<T> lit) {
            int id = ref.fieldId();
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return false;
            }
            Statistics<?> colStats = this.stats.get(id);
            if (colStats != null && !colStats.isEmpty()) {
                if (ParquetMetricsRowGroupFilter.hasNonNullButNoMinMax(colStats, valueCount)) {
                    return true;
                }
                if (!colStats.hasNonNullValue()) {
                    return false;
                }
                T lower = this.min(colStats, id);
                int cmp = lit.comparator().compare(lower, lit.value());
                if (cmp >= 0) {
                    return false;
                }
            }
            return true;
        }

        public <T> Boolean ltEq(BoundReference<T> ref, Literal<T> lit) {
            int id = ref.fieldId();
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return false;
            }
            Statistics<?> colStats = this.stats.get(id);
            if (colStats != null && !colStats.isEmpty()) {
                if (ParquetMetricsRowGroupFilter.hasNonNullButNoMinMax(colStats, valueCount)) {
                    return true;
                }
                if (!colStats.hasNonNullValue()) {
                    return false;
                }
                T lower = this.min(colStats, id);
                int cmp = lit.comparator().compare(lower, lit.value());
                if (cmp > 0) {
                    return false;
                }
            }
            return true;
        }

        public <T> Boolean gt(BoundReference<T> ref, Literal<T> lit) {
            int id = ref.fieldId();
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return false;
            }
            Statistics<?> colStats = this.stats.get(id);
            if (colStats != null && !colStats.isEmpty()) {
                if (ParquetMetricsRowGroupFilter.hasNonNullButNoMinMax(colStats, valueCount)) {
                    return true;
                }
                if (!colStats.hasNonNullValue()) {
                    return false;
                }
                T upper = this.max(colStats, id);
                int cmp = lit.comparator().compare(upper, lit.value());
                if (cmp <= 0) {
                    return false;
                }
            }
            return true;
        }

        public <T> Boolean gtEq(BoundReference<T> ref, Literal<T> lit) {
            int id = ref.fieldId();
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return false;
            }
            Statistics<?> colStats = this.stats.get(id);
            if (colStats != null && !colStats.isEmpty()) {
                if (ParquetMetricsRowGroupFilter.hasNonNullButNoMinMax(colStats, valueCount)) {
                    return true;
                }
                if (!colStats.hasNonNullValue()) {
                    return false;
                }
                T upper = this.max(colStats, id);
                int cmp = lit.comparator().compare(upper, lit.value());
                if (cmp < 0) {
                    return false;
                }
            }
            return true;
        }

        public <T> Boolean eq(BoundReference<T> ref, Literal<T> lit) {
            int id = ref.fieldId();
            if (ParquetMetricsRowGroupFilter.this.schema.findType(id) instanceof Type.NestedType) {
                return true;
            }
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return false;
            }
            Statistics<?> colStats = this.stats.get(id);
            if (colStats != null && !colStats.isEmpty()) {
                if (ParquetMetricsRowGroupFilter.hasNonNullButNoMinMax(colStats, valueCount)) {
                    return true;
                }
                if (!colStats.hasNonNullValue()) {
                    return false;
                }
                T lower = this.min(colStats, id);
                int cmp = lit.comparator().compare(lower, lit.value());
                if (cmp > 0) {
                    return false;
                }
                T upper = this.max(colStats, id);
                cmp = lit.comparator().compare(upper, lit.value());
                if (cmp < 0) {
                    return false;
                }
            }
            return true;
        }

        public <T> Boolean notEq(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        public <T> Boolean in(BoundReference<T> ref, Set<T> literalSet) {
            int id = ref.fieldId();
            if (ParquetMetricsRowGroupFilter.this.schema.findType(id) instanceof Type.NestedType) {
                return true;
            }
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return false;
            }
            Statistics<?> colStats = this.stats.get(id);
            if (colStats != null && !colStats.isEmpty()) {
                if (ParquetMetricsRowGroupFilter.hasNonNullButNoMinMax(colStats, valueCount)) {
                    return true;
                }
                if (!colStats.hasNonNullValue()) {
                    return false;
                }
                Collection<Object> literals = literalSet;
                if (literals.size() > 200) {
                    return true;
                }
                Object lower = this.min(colStats, id);
                if ((literals = (Collection)literals.stream().filter(v -> ref.comparator().compare(lower, v) <= 0).collect(Collectors.toList())).isEmpty()) {
                    return false;
                }
                Object upper = this.max(colStats, id);
                if ((literals = (Collection)literals.stream().filter(v -> ref.comparator().compare(upper, v) >= 0).collect(Collectors.toList())).isEmpty()) {
                    return false;
                }
            }
            return true;
        }

        public <T> Boolean notIn(BoundReference<T> ref, Set<T> literalSet) {
            return true;
        }

        public <T> Boolean startsWith(BoundReference<T> ref, Literal<T> lit) {
            int id = ref.fieldId();
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return false;
            }
            Statistics<?> colStats = this.stats.get(id);
            if (colStats != null && !colStats.isEmpty()) {
                if (ParquetMetricsRowGroupFilter.hasNonNullButNoMinMax(colStats, valueCount)) {
                    return true;
                }
                if (!colStats.hasNonNullValue()) {
                    return false;
                }
                ByteBuffer prefixAsBytes = lit.toByteBuffer();
                Comparator comparator = Comparators.unsignedBytes();
                Binary lower = (Binary)colStats.genericGetMin();
                int lowerLength = Math.min(prefixAsBytes.remaining(), lower.length());
                int lowerCmp = comparator.compare(BinaryUtil.truncateBinary((ByteBuffer)lower.toByteBuffer(), (int)lowerLength), prefixAsBytes);
                if (lowerCmp > 0) {
                    return false;
                }
                Binary upper = (Binary)colStats.genericGetMax();
                int upperLength = Math.min(prefixAsBytes.remaining(), upper.length());
                int upperCmp = comparator.compare(BinaryUtil.truncateBinary((ByteBuffer)upper.toByteBuffer(), (int)upperLength), prefixAsBytes);
                if (upperCmp < 0) {
                    return false;
                }
            }
            return true;
        }

        public <T> Boolean notStartsWith(BoundReference<T> ref, Literal<T> lit) {
            int id = ref.fieldId();
            Long valueCount = this.valueCounts.get(id);
            if (valueCount == null) {
                return true;
            }
            Statistics<?> colStats = this.stats.get(id);
            if (colStats != null && !colStats.isEmpty()) {
                if (ParquetMetricsRowGroupFilter.mayContainNull(colStats)) {
                    return true;
                }
                if (ParquetMetricsRowGroupFilter.hasNonNullButNoMinMax(colStats, valueCount)) {
                    return true;
                }
                Binary lower = (Binary)colStats.genericGetMin();
                Binary upper = (Binary)colStats.genericGetMax();
                if (lower != null && upper != null) {
                    ByteBuffer prefix = lit.toByteBuffer();
                    Comparator comparator = Comparators.unsignedBytes();
                    if (lower.length() < prefix.remaining()) {
                        return true;
                    }
                    int cmp = comparator.compare(BinaryUtil.truncateBinary((ByteBuffer)lower.toByteBuffer(), (int)prefix.remaining()), prefix);
                    if (cmp == 0) {
                        if (upper.length() < prefix.remaining()) {
                            return true;
                        }
                        cmp = comparator.compare(BinaryUtil.truncateBinary((ByteBuffer)upper.toByteBuffer(), (int)prefix.remaining()), prefix);
                        if (cmp == 0) {
                            return false;
                        }
                    }
                }
            }
            return true;
        }

        private <T> T min(Statistics<?> statistics, int id) {
            return (T)this.conversions.get(id).apply(statistics.genericGetMin());
        }

        private <T> T max(Statistics<?> statistics, int id) {
            return (T)this.conversions.get(id).apply(statistics.genericGetMax());
        }
    }
}

