/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.cbo;

import java.util.List;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.optimizer.cost.ICost;
import org.apache.asterix.optimizer.rules.cbo.JoinEnum;
import org.apache.asterix.optimizer.rules.cbo.JoinNode;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.HashJoinExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;

public class PlanNode {
    protected static int NO_PLAN = -1;
    private final JoinEnum joinEnum;
    protected String datasetName;
    protected ILogicalOperator leafInput;
    protected JoinNode jn;
    protected boolean outerJoin;
    protected int allPlansIndex;
    protected int[] jnIndexes;
    protected int[] planIndexes;
    protected ScanMethod scanOp;
    protected boolean indexHint;
    protected JoinMethod joinOp;
    protected ILogicalExpression joinExpr;
    protected HashJoinExpressionAnnotation.BuildSide side;
    protected IExpressionAnnotation joinHint;
    protected int numHintsUsed;
    protected ICost opCost;
    protected ICost totalCost;
    protected ICost leftExchangeCost;
    protected ICost rightExchangeCost;

    public int getIndex() {
        return this.allPlansIndex;
    }

    private int[] getPlanIndexes() {
        return this.planIndexes;
    }

    public PlanNode getLeftPlanNode() {
        if (this.planIndexes[0] == NO_PLAN) {
            return null;
        }
        return this.joinEnum.allPlans.get(this.planIndexes[0]);
    }

    public PlanNode getRightPlanNode() {
        if (this.planIndexes[1] == NO_PLAN) {
            return null;
        }
        return this.joinEnum.allPlans.get(this.planIndexes[1]);
    }

    protected JoinNode getJoinNode() {
        return this.jn;
    }

    protected void setJoinNode(JoinNode jn) {
        this.jn = jn;
    }

    public int getLeftJoinIndex() {
        return this.jnIndexes[0];
    }

    protected void setLeftJoinIndex(int index) {
        this.jnIndexes[0] = index;
    }

    public int getRightJoinIndex() {
        return this.jnIndexes[1];
    }

    protected void setRightJoinIndex(int index) {
        this.jnIndexes[1] = index;
    }

    protected int getLeftPlanIndex() {
        return this.planIndexes[0];
    }

    protected void setLeftPlanIndex(int index) {
        this.planIndexes[0] = index;
    }

    protected int getRightPlanIndex() {
        return this.planIndexes[1];
    }

    protected void setRightPlanIndex(int index) {
        this.planIndexes[1] = index;
    }

    public boolean IsScanNode() {
        return this.getLeftPlanIndex() == NO_PLAN && this.getRightPlanIndex() == NO_PLAN;
    }

    protected boolean IsJoinNode() {
        return this.getLeftPlanIndex() != NO_PLAN && this.getRightPlanIndex() != NO_PLAN;
    }

    public Pair<String, String> joinMethod() {
        if (this.joinOp == JoinMethod.HYBRID_HASH_JOIN) {
            return new Pair((Object)"HASH JOIN", (Object)"HJ");
        }
        if (this.joinOp == JoinMethod.BROADCAST_HASH_JOIN) {
            return new Pair((Object)"BROADCAST HASH JOIN", (Object)"BHJ");
        }
        if (this.joinOp == JoinMethod.INDEX_NESTED_LOOP_JOIN) {
            return new Pair((Object)"INDEX NESTED LOOPS JOIN", (Object)"INLJ");
        }
        if (this.joinOp == JoinMethod.CARTESIAN_PRODUCT_JOIN) {
            return new Pair((Object)"CARTESIAN PRODUCT JOIN", (Object)"CPJ");
        }
        return new Pair((Object)"", (Object)"");
    }

    private String getDatasetName() {
        return this.datasetName;
    }

    protected void setDatasetName(String dsName) {
        this.datasetName = dsName;
    }

    protected ILogicalOperator getLeafInput() {
        return this.leafInput;
    }

    protected void setLeafInput(ILogicalOperator leafInput) {
        this.leafInput = leafInput;
    }

    public ICost getOpCost() {
        return this.opCost;
    }

    protected void setOpCost(ICost cost) {
        this.opCost = cost;
    }

    protected double computeOpCost() {
        return this.opCost.computeTotalCost();
    }

    public ICost getTotalCost() {
        return this.totalCost;
    }

    protected void setTotalCost(ICost tc) {
        this.totalCost = tc;
    }

    public ICost getLeftExchangeCost() {
        return this.leftExchangeCost;
    }

    public ICost getRightExchangeCost() {
        return this.rightExchangeCost;
    }

    protected double computeTotalCost() {
        return this.totalCost.computeTotalCost();
    }

    public ScanMethod getScanOp() {
        return this.scanOp;
    }

    protected void setScanMethod(ScanMethod sm) {
        this.scanOp = sm;
    }

    protected JoinMethod getJoinOp() {
        return this.joinOp;
    }

    public ILogicalExpression getJoinExpr() {
        return this.joinExpr;
    }

    public PlanNode(int planIndex, JoinEnum joinE) {
        this.allPlansIndex = planIndex;
        this.joinEnum = joinE;
        this.jn = null;
        this.planIndexes = new int[2];
        this.jnIndexes = new int[2];
        this.setLeftJoinIndex(JoinNode.NO_JN);
        this.setRightJoinIndex(JoinNode.NO_JN);
        this.setLeftPlanIndex(NO_PLAN);
        this.setRightPlanIndex(NO_PLAN);
        this.opCost = this.totalCost = this.joinEnum.getCostHandle().zeroCost();
        this.outerJoin = false;
        this.indexHint = false;
        this.joinHint = null;
        this.numHintsUsed = 0;
    }

    public PlanNode(int planIndex, JoinEnum joinE, JoinNode joinNode, String datasetName, ILogicalOperator leafInput) {
        this.allPlansIndex = planIndex;
        this.joinEnum = joinE;
        this.setJoinNode(joinNode);
        this.datasetName = datasetName;
        this.leafInput = leafInput;
        this.planIndexes = new int[2];
        this.jnIndexes = new int[2];
        this.setLeftJoinIndex(this.jn.jnArrayIndex);
        this.setRightJoinIndex(JoinNode.NO_JN);
        this.setLeftPlanIndex(NO_PLAN);
        this.setRightPlanIndex(NO_PLAN);
        this.indexHint = false;
        this.joinHint = null;
        this.numHintsUsed = 0;
    }

    public PlanNode(int planIndex, JoinEnum joinE, JoinNode joinNode, PlanNode leftPlan, PlanNode rightPlan, boolean outerJoin) {
        this.allPlansIndex = planIndex;
        this.joinEnum = joinE;
        this.setJoinNode(joinNode);
        this.outerJoin = outerJoin;
        this.planIndexes = new int[2];
        this.jnIndexes = new int[2];
        this.setLeftJoinIndex(leftPlan.jn.jnArrayIndex);
        this.setRightJoinIndex(rightPlan.jn.jnArrayIndex);
        this.setLeftPlanIndex(leftPlan.allPlansIndex);
        this.setRightPlanIndex(rightPlan.allPlansIndex);
        this.indexHint = false;
        this.joinHint = null;
        this.numHintsUsed = 0;
    }

    protected void setScanAndHintInfo(ScanMethod scanMethod, List<Triple<Index, Double, AbstractFunctionCallExpression>> mandatoryIndexesInfo) {
        this.setScanMethod(scanMethod);
        if (mandatoryIndexesInfo.size() > 0) {
            this.indexHint = true;
            this.numHintsUsed = 1;
        }
    }

    protected void setScanCosts(ICost opCost) {
        this.opCost = opCost;
        this.totalCost = opCost;
    }

    protected void setJoinAndHintInfo(JoinMethod joinMethod, ILogicalExpression joinExpr, HashJoinExpressionAnnotation.BuildSide side, IExpressionAnnotation hint) {
        this.joinOp = joinMethod;
        this.joinExpr = joinExpr;
        this.side = side;
        this.joinHint = hint;
        this.numHintsUsed = this.joinEnum.allPlans.get((int)this.getLeftPlanIndex()).numHintsUsed + this.joinEnum.allPlans.get((int)this.getRightPlanIndex()).numHintsUsed;
        if (hint != null) {
            ++this.numHintsUsed;
        }
    }

    protected void setJoinCosts(ICost opCost, ICost totalCost, ICost leftExchangeCost, ICost rightExchangeCost) {
        this.opCost = opCost;
        this.totalCost = totalCost;
        this.leftExchangeCost = leftExchangeCost;
        this.rightExchangeCost = rightExchangeCost;
    }

    protected static enum JoinMethod {
        HYBRID_HASH_JOIN,
        BROADCAST_HASH_JOIN,
        INDEX_NESTED_LOOP_JOIN,
        CARTESIAN_PRODUCT_JOIN;

    }

    public static enum ScanMethod {
        INDEX_SCAN,
        TABLE_SCAN;

    }
}

