/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.primitive;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IComparable;
import org.apache.hyracks.data.std.api.IHashable;
import org.apache.hyracks.data.std.api.INumeric;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.FixedLengthTypeTrait;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.data.std.util.DataUtils;

public final class DoublePointable
extends AbstractPointable
implements IHashable,
IComparable,
INumeric {
    private static final int SIZE = 8;
    public static final DoublePointableFactory FACTORY = new DoublePointableFactory();
    public static final ITypeTraits TYPE_TRAITS = new FixedLengthTypeTrait(8){
        private static final long serialVersionUID = 7348262203696059687L;

        @Override
        public boolean isFixedLength() {
            return super.isFixedLength();
        }
    };
    private static final double MACHINE_EPSILON = DoublePointable.getMachineEpsilon();

    private static double getMachineEpsilon() {
        float epsilon = 1.0f;
        while ((double)((float)(1.0 + (double)(epsilon /= 2.0f) / 2.0)) != 1.0) {
        }
        return epsilon;
    }

    public static long getLongBits(byte[] bytes, int start) {
        return LongPointable.getLong(bytes, start);
    }

    public static double getDouble(byte[] bytes, int start) {
        long bits = DoublePointable.getLongBits(bytes, start);
        return Double.longBitsToDouble(bits);
    }

    public static void setDouble(byte[] bytes, int start, double value) {
        long bits = Double.doubleToLongBits(value);
        LongPointable.setLong(bytes, start, bits);
    }

    public double getDouble() {
        return DoublePointable.getDouble(this.bytes, this.start);
    }

    public void setDouble(double value) {
        DoublePointable.setDouble(this.bytes, this.start, value);
    }

    @Override
    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    @Override
    public int compareTo(byte[] bytes, int start, int length) {
        return DoublePointable.compare(this.bytes, this.start, this.length, bytes, start, length);
    }

    public static int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        DataUtils.ensureLengths(8, l1, l2);
        return Double.compare(DoublePointable.getDouble(b1, s1), DoublePointable.getDouble(b2, s2));
    }

    @Override
    public int hash() {
        long bits = DoublePointable.getLongBits(this.bytes, this.start);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public byte byteValue() {
        return (byte)this.getDouble();
    }

    @Override
    public short shortValue() {
        return (short)this.getDouble();
    }

    @Override
    public int intValue() {
        return (int)this.getDouble();
    }

    @Override
    public long longValue() {
        return (long)this.getDouble();
    }

    @Override
    public float floatValue() {
        return (float)this.getDouble();
    }

    @Override
    public double doubleValue() {
        return this.getDouble();
    }

    public static double getEpsilon() {
        return MACHINE_EPSILON;
    }

    public static class DoublePointableFactory
    implements IPointableFactory {
        private static final long serialVersionUID = 1L;

        @Override
        public IPointable createPointable() {
            return new DoublePointable();
        }

        @Override
        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
            return registry.getClassIdentifier(this.getClass(), 1L);
        }

        public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
            return FACTORY;
        }
    }
}

