/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.asterix.common.annotations.IRecordFieldDataGen;
import org.apache.asterix.common.annotations.UndeclaredFieldsDataGen;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.expression.AbstractTypeExpression;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class RecordTypeDefinition
extends AbstractTypeExpression {
    private final List<String> fieldNames = new ArrayList<String>();
    private final List<TypeExpression> fieldTypes = new ArrayList<TypeExpression>();
    private final List<IRecordFieldDataGen> fieldDataGen = new ArrayList<IRecordFieldDataGen>();
    private final List<Boolean> nullableFields = new ArrayList<Boolean>();
    private final List<Boolean> missableFields = new ArrayList<Boolean>();
    private RecordKind recordKind;
    private UndeclaredFieldsDataGen undeclaredFieldsDataGen;

    @Override
    public TypeExpression.TypeExprKind getTypeKind() {
        return TypeExpression.TypeExprKind.RECORD;
    }

    public void addField(String name, TypeExpression type, boolean nullable, boolean missable, IRecordFieldDataGen fldDataGen) {
        this.fieldNames.add(name);
        this.fieldTypes.add(type);
        this.nullableFields.add(nullable);
        this.missableFields.add(missable);
        this.fieldDataGen.add(fldDataGen);
    }

    public void addField(String name, TypeExpression type, boolean nullable, boolean missable) {
        this.fieldNames.add(name);
        this.fieldTypes.add(type);
        this.nullableFields.add(nullable);
        this.missableFields.add(missable);
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public List<TypeExpression> getFieldTypes() {
        return this.fieldTypes;
    }

    public List<Boolean> getNullableFields() {
        return this.nullableFields;
    }

    public List<Boolean> getMissableFields() {
        return this.missableFields;
    }

    public List<IRecordFieldDataGen> getFieldDataGen() {
        return this.fieldDataGen;
    }

    public RecordKind getRecordKind() {
        return this.recordKind;
    }

    public void setRecordKind(RecordKind recordKind) {
        this.recordKind = recordKind;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public void setUndeclaredFieldsDataGen(UndeclaredFieldsDataGen undeclaredFieldsDataGen) {
        this.undeclaredFieldsDataGen = undeclaredFieldsDataGen;
    }

    public UndeclaredFieldsDataGen getUndeclaredFieldsDataGen() {
        return this.undeclaredFieldsDataGen;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldDataGen, this.fieldNames, this.fieldTypes, this.nullableFields, this.missableFields, this.recordKind, this.undeclaredFieldsDataGen});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RecordTypeDefinition)) {
            return false;
        }
        RecordTypeDefinition target = (RecordTypeDefinition)object;
        return this.fieldDataGen.equals(target.getFieldDataGen()) && this.fieldNames.equals(target.getFieldNames()) && this.fieldTypes.equals(target.getFieldTypes()) && this.nullableFields.equals(target.getNullableFields()) && this.missableFields.equals(target.getMissableFields()) && Objects.equals((Object)this.recordKind, (Object)target.getRecordKind()) && Objects.equals(this.undeclaredFieldsDataGen, target.getUndeclaredFieldsDataGen());
    }

    public static enum RecordKind {
        OPEN,
        CLOSED;

    }
}

