/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.ipc.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.hyracks.ipc.api.IPayloadSerializerDeserializer;

public class JavaSerializationBasedPayloadSerializerDeserializer
implements IPayloadSerializerDeserializer {
    @Override
    public Object deserializeObject(ByteBuffer buffer, int length, byte flag) throws Exception {
        return this.deserialize(buffer, length);
    }

    @Override
    public Exception deserializeException(ByteBuffer buffer, int length) throws Exception {
        return (Exception)this.deserialize(buffer, length);
    }

    @Override
    public byte[] serializeObject(Object object) throws Exception {
        return this.serialize(object);
    }

    @Override
    public byte[] serializeException(Exception exception) throws Exception {
        return this.serialize(exception);
    }

    public static void serialize(OutputStream out, Object object) throws IOException {
        try (ObjectOutputStream oos = JavaSerializationUtils.getSerializationProvider().newObjectOutputStream(out);){
            oos.writeObject(object);
            oos.flush();
        }
    }

    private Object deserialize(ByteBuffer buffer, int length) throws Exception {
        Object object;
        try (ObjectInputStream ois = JavaSerializationUtils.getSerializationProvider().newObjectInputStream((InputStream)new ByteArrayInputStream(buffer.array(), buffer.position(), length));){
            object = ois.readObject();
        }
        return object;
    }

    private byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JavaSerializationBasedPayloadSerializerDeserializer.serialize(baos, object);
        baos.close();
        return baos.toByteArray();
    }
}

