/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs;

import java.io.IOException;
import java.util.List;
import org.apache.asterix.external.api.IExternalIndexer;
import org.apache.asterix.external.api.IIndexingDatasource;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.input.record.reader.hdfs.AbstractHDFSRecordReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class HDFSRecordReader<K, V extends Writable>
extends AbstractHDFSRecordReader<K, V>
implements IIndexingDatasource {
    private final IExternalIndexer indexer;
    private final List<ExternalFile> snapshot;
    private final FileSystem hdfs;

    public HDFSRecordReader(boolean[] read, InputSplit[] inputSplits, String[] readSchedule, String nodeName, JobConf conf, List<ExternalFile> snapshot, IExternalIndexer indexer) throws IOException {
        super(read, inputSplits, readSchedule, nodeName, conf);
        this.indexer = indexer;
        this.snapshot = snapshot;
        this.hdfs = FileSystem.get((Configuration)conf);
    }

    @Override
    protected RecordReader<K, V> getRecordReader(int splitIndex) throws IOException {
        this.reader = this.inputFormat.getRecordReader(this.inputSplits[splitIndex], this.conf, Reporter.NULL);
        if (this.key == null) {
            this.key = this.reader.createKey();
            this.value = this.reader.createValue();
        }
        if (this.indexer != null) {
            try {
                this.indexer.reset(this);
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        return this.reader;
    }

    @Override
    protected boolean onNextInputSplit() throws IOException {
        String fileName;
        FileStatus fileStatus;
        return this.snapshot != null && (fileStatus = this.hdfs.getFileStatus(new Path(fileName = ((FileSplit)this.inputSplits[this.currentSplitIndex]).getPath().toUri().getPath()))).getModificationTime() != this.snapshot.get(this.currentSplitIndex).getLastModefiedTime().getTime();
    }

    @Override
    public boolean stop() {
        return false;
    }

    @Override
    public IExternalIndexer getIndexer() {
        return this.indexer;
    }

    @Override
    public List<ExternalFile> getSnapshot() {
        return this.snapshot;
    }

    @Override
    public int getCurrentSplitIndex() {
        return this.currentSplitIndex;
    }

    @Override
    public RecordReader<K, V> getReader() {
        return this.reader;
    }
}

