/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.common.work.SynchronizableWork;

public class GatherStateDumpsWork
extends SynchronizableWork {
    private final ClusterControllerService ccs;
    private final StateDumpRun sdr;

    public GatherStateDumpsWork(ClusterControllerService ccs) {
        this.ccs = ccs;
        this.sdr = new StateDumpRun(ccs);
    }

    public void doRun() throws Exception {
        this.ccs.addStateDumpRun(this.sdr.stateDumpId, this.sdr);
        INodeManager nodeManager = this.ccs.getNodeManager();
        HashSet<String> nodeIds = new HashSet<String>();
        nodeIds.addAll(nodeManager.getAllNodeIds());
        this.sdr.setNCs(nodeIds);
        for (NodeControllerState ncs : nodeManager.getAllNodeControllerStates()) {
            ncs.getNodeController().dumpState(this.sdr.stateDumpId);
        }
    }

    public StateDumpRun getStateDumpRun() {
        return this.sdr;
    }

    public static class StateDumpRun {
        private final ClusterControllerService ccs;
        private final String stateDumpId;
        private final Map<String, String> ncStates;
        private Collection<String> ncIds;
        private boolean complete;

        public StateDumpRun(ClusterControllerService ccs) {
            this.ccs = ccs;
            this.stateDumpId = UUID.randomUUID().toString();
            this.ncStates = new HashMap<String, String>();
            this.complete = false;
        }

        public void setNCs(Collection<String> ncIds) {
            this.ncIds = ncIds;
        }

        public Map<String, String> getStateDump() {
            return this.ncStates;
        }

        public synchronized void notifyStateDumpReceived(String nodeId, String state) {
            this.ncIds.remove(nodeId);
            this.ncStates.put(nodeId, state);
            if (this.ncIds.size() == 0) {
                this.complete = true;
                this.ccs.removeStateDumpRun(this.stateDumpId);
                this.notifyAll();
            }
        }

        public synchronized void waitForCompletion() throws InterruptedException {
            while (!this.complete) {
                this.wait();
            }
        }

        public String getStateDumpId() {
            return this.stateDumpId;
        }
    }
}

