/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.util;

import java.util.BitSet;
import java.util.Comparator;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.dataflow.std.util.ReferenceEntry;

public class ReferencedPriorityQueue {
    private final ReferenceEntry[] entries;
    private final int size;
    private final BitSet runAvail;
    private int nItems;
    private final Comparator<ReferenceEntry> comparator;
    private final INormalizedKeyComputer nmkComputer;
    private final int[] keyFields;

    public ReferencedPriorityQueue(int initSize, Comparator<ReferenceEntry> comparator, int[] keyFields, INormalizedKeyComputer nmkComputer) {
        if (initSize < 1) {
            throw new IllegalArgumentException();
        }
        this.comparator = comparator;
        this.nmkComputer = nmkComputer;
        this.keyFields = keyFields;
        this.nItems = initSize;
        this.size = initSize + 1 & 0xFFFFFFFE;
        this.entries = new ReferenceEntry[this.size];
        this.runAvail = new BitSet(this.size);
        this.runAvail.set(0, initSize, true);
        for (int i = 0; i < this.size; ++i) {
            this.entries[i] = new ReferenceEntry(i, null, -1, keyFields, nmkComputer);
        }
    }

    public ReferenceEntry peek() {
        return this.entries[0];
    }

    public int popAndReplace(IFrameTupleAccessor fta, int tIndex) {
        ReferenceEntry entry = this.entries[0];
        entry.setAccessor(fta);
        entry.setTupleIndex(tIndex, this.keyFields, this.nmkComputer);
        this.add(entry);
        return entry.getRunid();
    }

    private void add(ReferenceEntry e) {
        ReferenceEntry min = this.entries[0];
        ReferenceEntry curr = e;
        for (int slot = (this.size >> 1) + (min.getRunid() >> 1); !this.runAvail.isEmpty() && slot > 0; slot >>= 1) {
            int c = 0;
            if (!this.runAvail.get(this.entries[slot].getRunid())) {
                c = 1;
            } else if (this.entries[slot].getAccessor() != null && this.runAvail.get(curr.getRunid())) {
                c = curr.getAccessor() != null ? this.comparator.compare(this.entries[slot], curr) : 1;
            }
            if (c > 0) continue;
            ReferenceEntry tmp = this.entries[slot];
            this.entries[slot] = curr;
            curr = tmp;
        }
        this.entries[0] = curr;
    }

    public ReferenceEntry pop() {
        ReferenceEntry min = this.entries[0];
        this.runAvail.clear(min.getRunid());
        this.add(min);
        --this.nItems;
        return min;
    }

    public boolean areRunsExhausted() {
        return this.runAvail.isEmpty();
    }

    public int size() {
        return this.nItems;
    }
}

