/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.paging;

import com.azure.core.util.IterableStream;
import com.azure.core.util.paging.ContinuablePage;
import com.azure.core.util.paging.ContinuablePagedFlux;
import java.util.stream.Stream;

public abstract class ContinuablePagedIterable<C, T, P extends ContinuablePage<C, T>>
extends IterableStream<T> {
    private final ContinuablePagedFlux<C, T, P> pagedFlux;
    private final int batchSize;

    public ContinuablePagedIterable(ContinuablePagedFlux<C, T, P> pagedFlux) {
        this(pagedFlux, 1);
    }

    public ContinuablePagedIterable(ContinuablePagedFlux<C, T, P> pagedFlux, int batchSize) {
        super(pagedFlux);
        this.pagedFlux = pagedFlux;
        this.batchSize = batchSize;
    }

    public Stream<P> streamByPage() {
        return this.pagedFlux.byPage().toStream(this.batchSize);
    }

    public Stream<P> streamByPage(C continuationToken) {
        return this.pagedFlux.byPage(continuationToken).toStream(this.batchSize);
    }

    public Stream<P> streamByPage(int preferredPageSize) {
        return this.pagedFlux.byPage(null, preferredPageSize).toStream(this.batchSize);
    }

    public Stream<P> streamByPage(C continuationToken, int preferredPageSize) {
        return this.pagedFlux.byPage(continuationToken, preferredPageSize).toStream(this.batchSize);
    }

    public Iterable<P> iterableByPage() {
        return this.pagedFlux.byPage().toIterable(this.batchSize);
    }

    public Iterable<P> iterableByPage(C continuationToken) {
        return this.pagedFlux.byPage(continuationToken).toIterable(this.batchSize);
    }

    public Iterable<P> iterableByPage(int preferredPageSize) {
        return this.pagedFlux.byPage(null, preferredPageSize).toIterable(this.batchSize);
    }

    public Iterable<P> iterableByPage(C continuationToken, int preferredPageSize) {
        return this.pagedFlux.byPage(continuationToken, preferredPageSize).toIterable(this.batchSize);
    }
}

