/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.pointables.nonvisitor;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.PriorityQueue;
import org.apache.asterix.dataflow.data.common.TaggedValueReference;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.om.pointables.nonvisitor.RecordField;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.asterix.om.util.container.ObjectFactories;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleOutputStream;
import org.apache.hyracks.util.string.UTF8StringWriter;

public final class SortedRecord {
    private static final IObjectFactory<RecordField, Void> FIELD_FACTORY = type -> new RecordField();
    private static final byte[] NULL_BYTES = new byte[]{ATypeTag.SERIALIZED_NULL_TYPE_TAG};
    private static final byte[] MISSING_BYTES = new byte[]{ATypeTag.SERIALIZED_MISSING_TYPE_TAG};
    private final IObjectPool<UTF8StringPointable, Void> utf8Pool = new ListObjectPool<UTF8StringPointable, Void>(ObjectFactories.UTF8_FACTORY);
    private final IObjectPool<RecordField, Void> recordFieldPool = new ListObjectPool<RecordField, Void>(FIELD_FACTORY);
    private final PriorityQueue<RecordField> sortedFields = new PriorityQueue<RecordField>(RecordField.FIELD_NAME_COMP);
    private final ARecordType recordType;
    private final IAType[] fieldTypes;
    private final RecordField[] closedFields;
    private final int numSchemaFields;
    private final boolean hasOptionalFields;
    private final int nullBitMapSize;
    private byte[] bytes;

    public SortedRecord(ARecordType recordType) {
        String[] fieldNames = recordType.getFieldNames();
        this.numSchemaFields = fieldNames.length;
        this.recordType = recordType;
        this.fieldTypes = recordType.getFieldTypes();
        this.hasOptionalFields = NonTaggedFormatUtil.hasOptionalField(recordType);
        this.nullBitMapSize = RecordUtil.computeNullBitmapSize(this.hasOptionalFields, recordType);
        this.closedFields = new RecordField[this.numSchemaFields];
        UTF8StringWriter utf8Writer = new UTF8StringWriter();
        ByteArrayAccessibleOutputStream byteArrayStream = new ByteArrayAccessibleOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)byteArrayStream);
        try {
            for (int i = 0; i < this.numSchemaFields; ++i) {
                int nameStart = dataOutputStream.size();
                utf8Writer.writeUTF8((CharSequence)fieldNames[i], (DataOutput)dataOutputStream);
                int nameEnd = dataOutputStream.size();
                UTF8StringPointable utf8Pointable = UTF8StringPointable.FACTORY.createPointable();
                utf8Pointable.set(byteArrayStream.getByteArray(), nameStart, nameEnd - nameStart);
                RecordField field = new RecordField();
                field.set(utf8Pointable, -1, -1, -1, null);
                this.closedFields[i] = field;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final void reset(byte[] data, int start) throws HyracksDataException {
        this.resetRecord(data, start, 1, 0);
    }

    public final void resetNonTagged(byte[] data, int start) throws HyracksDataException {
        this.resetRecord(data, start, 0, 1);
    }

    private void resetRecord(byte[] data, int start, int skipTag, int fixOffset) throws HyracksDataException {
        int length;
        ATypeTag tag;
        int fieldOffset;
        this.bytes = data;
        this.reset();
        boolean isExpanded = false;
        int pointer = start + skipTag + 4;
        if (this.recordType.isOpen()) {
            isExpanded = this.bytes[pointer] == 1;
            ++pointer;
        }
        int openPartOffset = 0;
        if (isExpanded) {
            openPartOffset = start + AInt32SerializerDeserializer.getInt(this.bytes, pointer) - fixOffset;
            pointer += 4;
        }
        int fieldIndex = 0;
        if (this.numSchemaFields > 0) {
            int nullBitMapOffset = pointer += 4;
            int fieldsOffsets = nullBitMapOffset + this.nullBitMapSize;
            int i = 0;
            while (i < this.numSchemaFields) {
                fieldOffset = AInt32SerializerDeserializer.getInt(this.bytes, fieldsOffsets) + start - fixOffset;
                tag = TypeComputeUtils.getActualType(this.fieldTypes[i]).getTypeTag();
                if (this.hasOptionalFields) {
                    byte nullBits = this.bytes[nullBitMapOffset + i / 4];
                    if (RecordUtil.isNull(nullBits, i)) {
                        tag = ATypeTag.NULL;
                    } else if (RecordUtil.isMissing(nullBits, i)) {
                        tag = ATypeTag.MISSING;
                    }
                }
                length = NonTaggedFormatUtil.getFieldValueLength(this.bytes, fieldOffset, tag, false);
                this.closedFields[i].set(fieldIndex, fieldOffset, length, tag);
                if (tag != ATypeTag.MISSING) {
                    this.sortedFields.add(this.closedFields[i]);
                }
                fieldsOffsets += 4;
                ++i;
                ++fieldIndex;
            }
        }
        if (isExpanded) {
            int numberOpenFields = AInt32SerializerDeserializer.getInt(this.bytes, openPartOffset);
            fieldOffset = openPartOffset + 4 + 8 * numberOpenFields;
            int i = 0;
            while (i < numberOpenFields) {
                length = NonTaggedFormatUtil.getFieldValueLength(this.bytes, fieldOffset, ATypeTag.STRING, false);
                UTF8StringPointable openFieldName = this.utf8Pool.allocate(null);
                openFieldName.set(this.bytes, fieldOffset, length);
                tag = ATypeTag.VALUE_TYPE_MAPPING[this.bytes[fieldOffset += length]];
                length = NonTaggedFormatUtil.getFieldValueLength(this.bytes, fieldOffset, tag, true) + 1;
                RecordField openField = this.recordFieldPool.allocate(null);
                openField.set(openFieldName, fieldIndex, fieldOffset, length, tag);
                this.sortedFields.add(openField);
                fieldOffset += length;
                ++i;
                ++fieldIndex;
            }
        }
    }

    private void reset() {
        this.sortedFields.clear();
        this.utf8Pool.reset();
        this.recordFieldPool.reset();
    }

    public final boolean isEmpty() {
        return this.sortedFields.isEmpty();
    }

    public final RecordField poll() {
        return this.sortedFields.poll();
    }

    public final int size() {
        return this.sortedFields.size();
    }

    public final IAType getFieldType(RecordField field) throws HyracksDataException {
        return RecordUtil.getType(this.recordType, field.getIndex(), field.getValueTag());
    }

    public final void getFieldValue(RecordField field, TaggedValueReference fieldValueRef) {
        if (field.getIndex() >= this.numSchemaFields) {
            fieldValueRef.set(this.bytes, field.getValueOffset() + 1, field.getValueLength() - 1, field.getValueTag());
        } else if (field.getValueTag() == ATypeTag.MISSING) {
            fieldValueRef.set(MISSING_BYTES, 0, 0, ATypeTag.MISSING);
        } else if (field.getValueTag() == ATypeTag.NULL) {
            fieldValueRef.set(NULL_BYTES, 0, 0, ATypeTag.NULL);
        } else {
            fieldValueRef.set(this.bytes, field.getValueOffset(), field.getValueLength(), field.getValueTag());
        }
    }

    public final void getFieldValue(RecordField field, IPointable pointable, ArrayBackedValueStorage storage) throws IOException {
        int fieldIdx = field.getIndex();
        if (fieldIdx >= this.numSchemaFields) {
            pointable.set(this.bytes, field.getValueOffset(), field.getValueLength());
        } else if (field.getValueTag() == ATypeTag.MISSING) {
            pointable.set(MISSING_BYTES, 0, MISSING_BYTES.length);
        } else if (field.getValueTag() == ATypeTag.NULL) {
            pointable.set(NULL_BYTES, 0, NULL_BYTES.length);
        } else {
            int start = storage.getLength();
            storage.getDataOutput().writeByte(field.getValueTag().serialize());
            storage.getDataOutput().write(this.bytes, field.getValueOffset(), field.getValueLength());
            int end = storage.getLength();
            pointable.set(storage.getByteArray(), start, end - start);
        }
    }
}

