/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.usearnregion;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.s3.internal.usearnregion.ProfileUseArnRegionProvider;
import software.amazon.awssdk.services.s3.internal.usearnregion.SystemsSettingsUseArnRegionProvider;
import software.amazon.awssdk.services.s3.internal.usearnregion.UseArnRegionProvider;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class UseArnRegionProviderChain
implements UseArnRegionProvider {
    private static final Logger log = Logger.loggerFor(UseArnRegionProvider.class);
    private static final List<UseArnRegionProvider> DEFAULT_PROVIDERS = Arrays.asList(SystemsSettingsUseArnRegionProvider.create(), ProfileUseArnRegionProvider.create());
    private static final UseArnRegionProviderChain INSTANCE = new UseArnRegionProviderChain();

    private UseArnRegionProviderChain() {
    }

    public static UseArnRegionProviderChain create() {
        return INSTANCE;
    }

    @Override
    public Optional<Boolean> resolveUseArnRegion() {
        for (UseArnRegionProvider provider : DEFAULT_PROVIDERS) {
            try {
                Optional<Boolean> useArnRegion = provider.resolveUseArnRegion();
                if (!useArnRegion.isPresent()) continue;
                return useArnRegion;
            }
            catch (Exception ex) {
                log.warn(() -> "Failed to retrieve useArnRegion from " + provider);
            }
        }
        return Optional.empty();
    }
}

