/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MemoryFileUpload;
import io.netty.handler.stream.ChunkedInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import reactor.core.Exceptions;
import reactor.core.publisher.DirectProcessor;
import reactor.netty.http.client.HttpClientForm;

final class HttpClientFormEncoder
extends HttpPostRequestEncoder
implements ChunkedInput<HttpContent>,
Runnable,
HttpClientForm {
    final DirectProcessor<Long> progressFlux;
    final HttpRequest request;
    boolean needNewEncoder;
    HttpDataFactory newFactory;
    boolean cleanOnTerminate;
    Charset newCharset;
    boolean newMultipart;
    HttpPostRequestEncoder.EncoderMode newMode;
    static final Map<Pattern, String> percentEncodings = new HashMap<Pattern, String>();
    static final String DEFAULT_BINARY_CONTENT_TYPE = "application/octet-stream";
    static final String DEFAULT_TRANSFER_ENCODING = "binary";
    static final String DEFAULT_TEXT_CONTENT_TYPE = "text/plain";

    HttpClientFormEncoder(HttpDataFactory factory, HttpRequest request, boolean multipart, Charset charset, HttpPostRequestEncoder.EncoderMode encoderMode) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        super(factory, request, multipart, charset, encoderMode);
        this.newCharset = charset;
        this.request = request;
        this.cleanOnTerminate = true;
        this.progressFlux = DirectProcessor.create();
        this.newMode = encoderMode;
        this.newFactory = factory;
        this.newMultipart = multipart;
    }

    public HttpContent readChunk(ByteBufAllocator allocator) throws Exception {
        HttpContent c = super.readChunk(allocator);
        if (c == null) {
            this.progressFlux.onComplete();
        } else {
            this.progressFlux.onNext((Object)this.progress());
            if (this.isEndOfInput()) {
                this.progressFlux.onComplete();
            }
        }
        return c;
    }

    @Override
    public HttpClientForm attr(String name, String value) {
        try {
            this.addBodyAttribute(name, value);
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        return this;
    }

    @Override
    public HttpClientForm charset(Charset charset) {
        this.newCharset = Objects.requireNonNull(charset, "charset");
        this.needNewEncoder = true;
        return this;
    }

    @Override
    public HttpClientForm cleanOnTerminate(boolean clean) {
        this.cleanOnTerminate = clean;
        return this;
    }

    @Override
    public HttpClientForm factory(HttpDataFactory factory) {
        if (!this.getBodyListAttributes().isEmpty()) {
            throw new IllegalStateException("Cannot set a new HttpDataFactory after starting appending Parts, call factory(f) at the earliest occasion offered");
        }
        this.newFactory = Objects.requireNonNull(factory, "factory");
        this.needNewEncoder = true;
        return this.applyChanges(this.request);
    }

    @Override
    public HttpClientForm file(String name, File file) {
        this.file(name, file, null);
        return this;
    }

    @Override
    public HttpClientForm file(String name, InputStream inputStream) {
        this.file(name, inputStream, null);
        return this;
    }

    @Override
    public HttpClientForm file(String name, String filename, File file, @Nullable String contentType) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(file, "file");
        Objects.requireNonNull(filename, "filename");
        String scontentType = contentType;
        if (contentType == null) {
            scontentType = DEFAULT_BINARY_CONTENT_TYPE;
        }
        FileUpload fileUpload = this.newFactory.createFileUpload(this.request, name, filename, scontentType, DEFAULT_TRANSFER_ENCODING, null, file.length());
        try {
            fileUpload.setContent(file);
            this.addBodyHttpData((InterfaceHttpData)fileUpload);
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)new HttpPostRequestEncoder.ErrorDataEncoderException((Throwable)e));
        }
        return this;
    }

    @Override
    public HttpClientForm file(String name, String filename, InputStream stream, @Nullable String contentType) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(stream, "stream");
        try {
            String scontentType = contentType;
            if (contentType == null) {
                scontentType = DEFAULT_BINARY_CONTENT_TYPE;
            }
            MemoryFileUpload fileUpload = new MemoryFileUpload(name, filename, scontentType, DEFAULT_TRANSFER_ENCODING, this.newCharset, -1L);
            fileUpload.setMaxSize(-1L);
            fileUpload.setContent(stream);
            this.addBodyHttpData((InterfaceHttpData)fileUpload);
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)new HttpPostRequestEncoder.ErrorDataEncoderException((Throwable)e));
        }
        return this;
    }

    @Override
    public HttpClientForm files(String name, File[] files, String[] contentTypes) {
        for (int i = 0; i < files.length; ++i) {
            this.file(name, files[i], contentTypes[i]);
        }
        return this;
    }

    @Override
    public HttpClientForm files(String name, File[] files, String[] contentTypes, boolean[] textFiles) {
        try {
            this.addBodyFileUploads(name, files, contentTypes, textFiles);
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        return this;
    }

    @Override
    public HttpClientForm encoding(HttpPostRequestEncoder.EncoderMode mode) {
        this.newMode = Objects.requireNonNull(mode, "mode");
        this.needNewEncoder = true;
        return this;
    }

    @Override
    public HttpClientForm multipart(boolean isMultipart) {
        this.needNewEncoder = this.isChunked() != isMultipart;
        this.newMultipart = isMultipart;
        return this;
    }

    @Override
    public HttpClientForm textFile(String name, File file) {
        this.textFile(name, file, null);
        return this;
    }

    @Override
    public HttpClientForm textFile(String name, File file, @Nullable String contentType) {
        try {
            this.addBodyFileUpload(name, file, contentType, true);
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        return this;
    }

    @Override
    public HttpClientForm textFile(String name, InputStream stream) {
        this.textFile(name, stream, null);
        return this;
    }

    @Override
    public HttpClientForm textFile(String name, InputStream stream, @Nullable String contentType) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(stream, "stream");
        try {
            String scontentType = contentType;
            if (contentType == null) {
                scontentType = DEFAULT_TEXT_CONTENT_TYPE;
            }
            MemoryFileUpload fileUpload = new MemoryFileUpload(name, "", scontentType, null, this.newCharset, -1L);
            fileUpload.setMaxSize(-1L);
            fileUpload.setContent(stream);
            this.addBodyHttpData((InterfaceHttpData)fileUpload);
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)new HttpPostRequestEncoder.ErrorDataEncoderException((Throwable)e));
        }
        return this;
    }

    @Override
    public void run() {
        this.cleanFiles();
    }

    final HttpClientFormEncoder applyChanges(HttpRequest request) {
        if (!this.needNewEncoder) {
            return this;
        }
        try {
            HttpClientFormEncoder encoder = new HttpClientFormEncoder(this.newFactory, request, this.newMultipart, this.newCharset, this.newMode);
            encoder.setBodyHttpDatas(this.getBodyListAttributes());
            return encoder;
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException ee) {
            throw Exceptions.propagate((Throwable)ee);
        }
    }

    static {
        DiskFileUpload.deleteOnExitTemporaryFile = true;
        DiskFileUpload.baseDirectory = null;
        DiskAttribute.deleteOnExitTemporaryFile = true;
        DiskAttribute.baseDirectory = null;
        percentEncodings.put(Pattern.compile("\\*"), "%2A");
        percentEncodings.put(Pattern.compile("\\+"), "%20");
        percentEncodings.put(Pattern.compile("%7E"), "~");
    }
}

