/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.ArgumentUtils;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

@MissingNullInOutFunction
public class StringRepeatDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = StringRepeatDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private IScalarEvaluator evalString;
                    private IScalarEvaluator evalStart;
                    private IPointable argString;
                    private IPointable argNumber;
                    private final AMutableInt32 mutableInt;
                    private ArrayBackedValueStorage resultStorage;
                    private DataOutput out;
                    private byte[] tempLengthArray;
                    {
                        this.evalString = args[0].createScalarEvaluator(ctx);
                        this.evalStart = args[1].createScalarEvaluator(ctx);
                        this.argString = new VoidPointable();
                        this.argNumber = new VoidPointable();
                        this.mutableInt = new AMutableInt32(0);
                        this.resultStorage = new ArrayBackedValueStorage();
                        this.out = this.resultStorage.getDataOutput();
                        this.tempLengthArray = new byte[5];
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.evalString.evaluate(tuple, this.argString);
                        this.evalStart.evaluate(tuple, this.argNumber);
                        if (PointableHelper.checkAndSetMissingOrNull(result, this.argString, this.argNumber)) {
                            return;
                        }
                        byte[] bytes = this.argNumber.getByteArray();
                        int offset = this.argNumber.getStartOffset();
                        if (!ArgumentUtils.setInteger(ctx, StringRepeatDescriptor.this.sourceLoc, StringRepeatDescriptor.this.getIdentifier(), 1, bytes, offset, this.mutableInt)) {
                            PointableHelper.setNull(result);
                            return;
                        }
                        int repeatingTimes = this.mutableInt.getIntegerValue();
                        if (repeatingTimes < 0) {
                            PointableHelper.setNull(result);
                            ExceptionUtil.warnNegativeValue((IEvaluatorContext)ctx, (SourceLocation)StringRepeatDescriptor.this.sourceLoc, (FunctionIdentifier)StringRepeatDescriptor.this.getIdentifier(), (int)1, (double)repeatingTimes);
                            return;
                        }
                        bytes = this.argString.getByteArray();
                        if (bytes[offset = this.argString.getStartOffset()] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                            PointableHelper.setNull(result);
                            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)ctx, (SourceLocation)StringRepeatDescriptor.this.sourceLoc, (FunctionIdentifier)StringRepeatDescriptor.this.getIdentifier(), (byte)bytes[offset], (int)0, (ATypeTag)ATypeTag.STRING);
                            return;
                        }
                        int inputLen = UTF8StringUtil.getUTFLength((byte[])bytes, (int)(offset + 1));
                        int resultLen = Math.multiplyExact(inputLen, repeatingTimes);
                        int cbytes = UTF8StringUtil.encodeUTF8Length((int)resultLen, (byte[])this.tempLengthArray, (int)0);
                        int inputStringStart = offset + 1 + UTF8StringUtil.getNumBytesToStoreLength((int)inputLen);
                        try {
                            this.out.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            this.out.write(this.tempLengthArray, 0, cbytes);
                            for (int numRepeats = 0; numRepeats < repeatingTimes; ++numRepeats) {
                                this.out.write(bytes, inputStringStart, inputLen);
                            }
                        }
                        catch (IOException e) {
                            throw HyracksDataException.create((Throwable)e);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.STRING_REPEAT;
    }
}

