/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TransitionStorageClass {
    GLACIER("GLACIER"),
    STANDARD_IA("STANDARD_IA"),
    ONEZONE_IA("ONEZONE_IA"),
    INTELLIGENT_TIERING("INTELLIGENT_TIERING"),
    DEEP_ARCHIVE("DEEP_ARCHIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TransitionStorageClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransitionStorageClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TransitionStorageClass.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TransitionStorageClass> knownValues() {
        return Stream.of(TransitionStorageClass.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

