/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IDestroyable;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingFrameTupleReference;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.api.ILSMIndexCursor;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITupleFilter;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.util.ResourceReleaseUtils;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.util.IThreadStatsCollector;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class IndexSearchOperatorNodePushable
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    static final Logger LOGGER = LogManager.getLogger();
    protected final IHyracksTaskContext ctx;
    protected final IIndexDataflowHelper indexHelper;
    protected FrameTupleAccessor accessor;
    protected FrameTupleAppender appender;
    protected ArrayTupleBuilder tb;
    protected DataOutput dos;
    protected IIndex index;
    protected ISearchPredicate searchPred;
    protected IIndexCursor cursor;
    protected IIndexAccessor indexAccessor;
    protected final RecordDescriptor inputRecDesc;
    protected final boolean retainInput;
    protected FrameTupleReference frameTuple;
    protected final boolean retainMissing;
    protected ArrayTupleBuilder nonMatchTupleBuild;
    protected IMissingWriter nonMatchWriter;
    protected final int[] minFilterFieldIndexes;
    protected final int[] maxFilterFieldIndexes;
    protected PermutingFrameTupleReference minFilterKey;
    protected PermutingFrameTupleReference maxFilterKey;
    protected final boolean appendIndexFilter;
    protected ArrayTupleBuilder nonFilterTupleBuild;
    protected final ISearchOperationCallbackFactory searchCallbackFactory;
    protected boolean failed = false;
    protected IOperatorStats stats;
    protected boolean appendSearchCallbackProceedResult;
    protected byte[] searchCallbackProceedResultFalseValue;
    protected byte[] searchCallbackProceedResultTrueValue;
    protected final ITupleFilterFactory tupleFilterFactory;
    protected ReferenceFrameTupleReference referenceFilterTuple;
    protected ITupleFilter tupleFilter;
    protected final long outputLimit;
    protected long outputCount = 0L;
    protected boolean finished;

    public IndexSearchOperatorNodePushable(IHyracksTaskContext ctx, RecordDescriptor inputRecDesc, int partition, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes, IIndexDataflowHelperFactory indexHelperFactory, boolean retainInput, boolean retainMissing, IMissingWriterFactory missingWriterFactory, ISearchOperationCallbackFactory searchCallbackFactory, boolean appendIndexFilter) throws HyracksDataException {
        this(ctx, inputRecDesc, partition, minFilterFieldIndexes, maxFilterFieldIndexes, indexHelperFactory, retainInput, retainMissing, missingWriterFactory, searchCallbackFactory, appendIndexFilter, null, -1L, false, null, null);
    }

    public IndexSearchOperatorNodePushable(IHyracksTaskContext ctx, RecordDescriptor inputRecDesc, int partition, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes, IIndexDataflowHelperFactory indexHelperFactory, boolean retainInput, boolean retainMissing, IMissingWriterFactory missingWriterFactory, ISearchOperationCallbackFactory searchCallbackFactory, boolean appendIndexFilter, ITupleFilterFactory tupleFactoryFactory, long outputLimit, boolean appendSearchCallbackProceedResult, byte[] searchCallbackProceedResultFalseValue, byte[] searchCallbackProceedResultTrueValue) throws HyracksDataException {
        this.ctx = ctx;
        this.indexHelper = indexHelperFactory.create(ctx.getJobletContext().getServiceContext(), partition);
        this.retainInput = retainInput;
        this.retainMissing = retainMissing;
        this.appendIndexFilter = appendIndexFilter;
        if (this.retainMissing || this.appendIndexFilter) {
            this.nonMatchWriter = missingWriterFactory.createMissingWriter();
        }
        this.inputRecDesc = inputRecDesc;
        this.searchCallbackFactory = searchCallbackFactory;
        this.minFilterFieldIndexes = minFilterFieldIndexes;
        this.maxFilterFieldIndexes = maxFilterFieldIndexes;
        if (minFilterFieldIndexes != null && minFilterFieldIndexes.length > 0) {
            this.minFilterKey = new PermutingFrameTupleReference();
            this.minFilterKey.setFieldPermutation(minFilterFieldIndexes);
        }
        if (maxFilterFieldIndexes != null && maxFilterFieldIndexes.length > 0) {
            this.maxFilterKey = new PermutingFrameTupleReference();
            this.maxFilterKey.setFieldPermutation(maxFilterFieldIndexes);
        }
        this.appendSearchCallbackProceedResult = appendSearchCallbackProceedResult;
        this.searchCallbackProceedResultFalseValue = searchCallbackProceedResultFalseValue;
        this.searchCallbackProceedResultTrueValue = searchCallbackProceedResultTrueValue;
        this.tupleFilterFactory = tupleFactoryFactory;
        this.outputLimit = outputLimit;
        if (ctx != null && ctx.getStatsCollector() != null) {
            this.stats = ctx.getStatsCollector().getOrAddOperatorStats(this.getDisplayName());
        }
        if (this.tupleFilterFactory != null && this.retainMissing) {
            throw new IllegalStateException("RetainMissing with tuple filter is not supported");
        }
    }

    protected abstract ISearchPredicate createSearchPredicate();

    protected abstract void resetSearchPredicate(int var1);

    protected abstract void addAdditionalIndexAccessorParams(IIndexAccessParameters var1) throws HyracksDataException;

    protected IIndexCursor createCursor() throws HyracksDataException {
        return this.indexAccessor.createSearchCursor(false);
    }

    protected abstract int getFieldCount();

    public void open() throws HyracksDataException {
        this.writer.open();
        this.indexHelper.open();
        this.index = this.indexHelper.getIndexInstance();
        this.subscribeForStats(this.index);
        this.accessor = new FrameTupleAccessor(this.inputRecDesc);
        if (this.retainMissing) {
            int fieldCount = this.getFieldCount();
            int finalFieldCount = this.appendSearchCallbackProceedResult ? fieldCount + 1 : fieldCount;
            this.nonMatchTupleBuild = new ArrayTupleBuilder(finalFieldCount);
            IndexSearchOperatorNodePushable.buildMissingTuple(fieldCount, this.nonMatchTupleBuild, this.nonMatchWriter);
            if (this.appendSearchCallbackProceedResult) {
                this.writeSearchCallbackProceedResult(this.nonMatchTupleBuild, true);
            }
        } else {
            this.nonMatchTupleBuild = null;
        }
        if (this.appendIndexFilter) {
            int numIndexFilterFields = this.index.getNumOfFilterFields();
            this.nonFilterTupleBuild = new ArrayTupleBuilder(numIndexFilterFields);
            IndexSearchOperatorNodePushable.buildMissingTuple(numIndexFilterFields, this.nonFilterTupleBuild, this.nonMatchWriter);
        }
        if (this.tupleFilterFactory != null) {
            this.tupleFilter = this.tupleFilterFactory.createTupleFilter(this.ctx);
            this.referenceFilterTuple = new ReferenceFrameTupleReference();
        }
        this.finished = false;
        this.outputCount = 0L;
        try {
            this.searchPred = this.createSearchPredicate();
            this.tb = new ArrayTupleBuilder(this.recordDesc.getFieldCount());
            this.dos = this.tb.getDataOutput();
            this.appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)this.ctx), true);
            ISearchOperationCallback searchCallback = this.searchCallbackFactory.createSearchOperationCallback(this.indexHelper.getResource().getId(), this.ctx, null);
            IndexAccessParameters iap = new IndexAccessParameters(NoOpOperationCallback.INSTANCE, searchCallback);
            this.addAdditionalIndexAccessorParams(iap);
            this.indexAccessor = this.index.createAccessor((IIndexAccessParameters)iap);
            this.cursor = this.createCursor();
            if (this.retainInput) {
                this.frameTuple = new FrameTupleReference();
            }
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected void writeSearchResults(int tupleIndex) throws Exception {
        long matchingTupleCount = 0L;
        while (this.cursor.hasNext()) {
            this.cursor.next();
            ++matchingTupleCount;
            ITupleReference tuple = this.cursor.getTuple();
            if (this.tupleFilter != null && !this.tupleFilter.accept(this.referenceFilterTuple.reset(tuple))) continue;
            this.tb.reset();
            if (this.retainInput) {
                this.frameTuple.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
                for (int i = 0; i < this.frameTuple.getFieldCount(); ++i) {
                    this.dos.write(this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), this.frameTuple.getFieldLength(i));
                    this.tb.addFieldEndOffset();
                }
            }
            this.writeTupleToOutput(tuple);
            if (this.appendSearchCallbackProceedResult) {
                this.writeSearchCallbackProceedResult(this.tb, ((ILSMIndexCursor)this.cursor).getSearchOperationCallbackProceedResult());
            }
            if (this.appendIndexFilter) {
                this.writeFilterTupleToOutput(((ILSMIndexCursor)this.cursor).getFilterMinTuple());
                this.writeFilterTupleToOutput(((ILSMIndexCursor)this.cursor).getFilterMaxTuple());
            }
            FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (int[])this.tb.getFieldEndOffsets(), (byte[])this.tb.getByteArray(), (int)0, (int)this.tb.getSize());
            if (this.outputLimit < 0L || ++this.outputCount < this.outputLimit) continue;
            this.finished = true;
            break;
        }
        this.stats.getTupleCounter().update(matchingTupleCount);
        if (matchingTupleCount == 0L && this.retainInput && this.retainMissing) {
            FrameUtils.appendConcatToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (IFrameTupleAccessor)this.accessor, (int)tupleIndex, (int[])this.nonMatchTupleBuild.getFieldEndOffsets(), (byte[])this.nonMatchTupleBuild.getByteArray(), (int)0, (int)this.nonMatchTupleBuild.getSize());
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        try {
            for (int i = 0; i < tupleCount && !this.finished; ++i) {
                this.resetSearchPredicate(i);
                this.cursor.close();
                this.indexAccessor.search(this.cursor, this.searchPred);
                this.writeSearchResults(i);
            }
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void flush() throws HyracksDataException {
        this.appender.flush(this.writer);
    }

    public void close() throws HyracksDataException {
        Throwable failure = this.releaseResources();
        if ((failure = CleanupUtils.close((IFrameWriter)this.writer, (Throwable)failure)) != null) {
            throw HyracksDataException.create((Throwable)failure);
        }
    }

    private Throwable releaseResources() {
        Throwable failure = null;
        if (this.index != null) {
            if (!this.failed) {
                try {
                    if (this.appender.getTupleCount() > 0) {
                        this.appender.write(this.writer, true);
                    }
                    this.stats.getDiskIoCounter().update(this.ctx.getThreadStats().getPinnedPagesCount());
                }
                catch (Throwable th) {
                    failure = th;
                }
                if (failure != null) {
                    try {
                        this.writer.fail();
                    }
                    catch (Throwable th) {
                        failure = ExceptionUtils.suppress((Throwable)failure, (Throwable)th);
                    }
                }
            }
            failure = ResourceReleaseUtils.close(this.cursor, failure);
            failure = CleanupUtils.destroy((Throwable)failure, (IDestroyable[])new IDestroyable[]{this.cursor, this.indexAccessor});
            failure = ResourceReleaseUtils.close(this.indexHelper, failure);
        }
        return failure;
    }

    public void fail() throws HyracksDataException {
        this.failed = true;
        this.writer.fail();
    }

    private void subscribeForStats(IIndex index) {
        if (index.getBufferCache() instanceof IThreadStatsCollector) {
            this.ctx.subscribeThreadToStats((IThreadStatsCollector)index.getBufferCache());
        }
    }

    protected void writeTupleToOutput(ITupleReference tuple) throws IOException {
        for (int i = 0; i < tuple.getFieldCount(); ++i) {
            this.dos.write(tuple.getFieldData(i), tuple.getFieldStart(i), tuple.getFieldLength(i));
            this.tb.addFieldEndOffset();
        }
    }

    private void writeSearchCallbackProceedResult(ArrayTupleBuilder atb, boolean searchCallbackProceedResult) throws HyracksDataException {
        if (!searchCallbackProceedResult) {
            atb.addField(this.searchCallbackProceedResultFalseValue, 0, this.searchCallbackProceedResultFalseValue.length);
        } else {
            atb.addField(this.searchCallbackProceedResultTrueValue, 0, this.searchCallbackProceedResultTrueValue.length);
        }
    }

    private void writeFilterTupleToOutput(ITupleReference tuple) throws IOException {
        if (tuple != null) {
            this.writeTupleToOutput(tuple);
        } else {
            int[] offsets = this.nonFilterTupleBuild.getFieldEndOffsets();
            for (int i = 0; i < offsets.length; ++i) {
                int start = i > 0 ? offsets[i - 1] : 0;
                this.tb.addField(this.nonFilterTupleBuild.getByteArray(), start, offsets[i]);
            }
        }
    }

    private static void buildMissingTuple(int numFields, ArrayTupleBuilder nullTuple, IMissingWriter nonMatchWriter) {
        DataOutput out = nullTuple.getDataOutput();
        for (int i = 0; i < numFields; ++i) {
            try {
                nonMatchWriter.writeMissing(out);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARN, e.getMessage(), (Throwable)e);
            }
            nullTuple.addFieldEndOffset();
        }
    }

    public String getDisplayName() {
        return "Index Search";
    }

    protected static class ReferenceFrameTupleReference
    implements IFrameTupleReference {
        private ITupleReference tuple;

        protected ReferenceFrameTupleReference() {
        }

        public IFrameTupleReference reset(ITupleReference tuple) {
            this.tuple = tuple;
            return this;
        }

        public int getFieldCount() {
            return this.tuple.getFieldCount();
        }

        public byte[] getFieldData(int fIdx) {
            return this.tuple.getFieldData(fIdx);
        }

        public int getFieldStart(int fIdx) {
            return this.tuple.getFieldStart(fIdx);
        }

        public int getFieldLength(int fIdx) {
            return this.tuple.getFieldLength(fIdx);
        }

        public IFrameTupleAccessor getFrameTupleAccessor() {
            throw new UnsupportedOperationException("getFrameTupleAccessor is not supported by ReferenceFrameTupleReference");
        }

        public int getTupleIndex() {
            throw new UnsupportedOperationException("getTupleIndex is not supported by ReferenceFrameTupleReference");
        }
    }
}

