/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.event;

import com.couchbase.client.core.event.CouchbaseEvent;
import com.couchbase.client.core.event.EventBus;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import rx.Observable;
import rx.Scheduler;
import rx.subjects.PublishSubject;
import rx.subjects.Subject;

public class DefaultEventBus
implements EventBus {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(DefaultEventBus.class);
    private final Subject<CouchbaseEvent, CouchbaseEvent> bus = PublishSubject.create().toSerialized();
    private final Scheduler scheduler;

    public DefaultEventBus(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public Observable<CouchbaseEvent> get() {
        return this.bus.onBackpressureDrop().observeOn(this.scheduler);
    }

    @Override
    public void publish(CouchbaseEvent event) {
        if (this.bus.hasObservers()) {
            try {
                this.bus.onNext((Object)event);
            }
            catch (Exception ex) {
                LOGGER.warn("Caught exception during event emission, moving on.", ex);
            }
        }
    }

    @Override
    public boolean hasSubscribers() {
        return this.bus.hasObservers();
    }
}

