/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.lock;

import java.util.Objects;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.IMetadataLock;

final class MetadataLockKey
implements IMetadataLock.LockKey {
    private final EntityKind entityKind;
    private final String entityKindExtension;
    private final DataverseName dataverseName;
    private final String entityName;

    private MetadataLockKey(EntityKind entityKind, String entityKindExtension, DataverseName dataverseName, String entityName) {
        if (entityKind == null || dataverseName == null && entityName == null) {
            throw new NullPointerException();
        }
        this.entityKind = entityKind;
        this.entityKindExtension = entityKindExtension;
        this.dataverseName = dataverseName;
        this.entityName = entityName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataLockKey that = (MetadataLockKey)o;
        return this.entityKind == that.entityKind && Objects.equals(this.entityKindExtension, that.entityKindExtension) && Objects.equals(this.dataverseName, that.dataverseName) && Objects.equals(this.entityName, that.entityName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entityKind, this.entityKindExtension, this.dataverseName, this.entityName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append((Object)this.entityKind);
        if (this.entityKindExtension != null) {
            sb.append(':').append(this.entityKindExtension);
        }
        if (this.dataverseName != null) {
            sb.append(':').append(this.dataverseName.getCanonicalForm());
        }
        sb.append(':').append(this.entityName);
        return sb.toString();
    }

    static MetadataLockKey createDataverseLockKey(DataverseName dataverseName) {
        return new MetadataLockKey(EntityKind.DATAVERSE, null, dataverseName, null);
    }

    static MetadataLockKey createDatasetLockKey(DataverseName dataverseName, String datasetName) {
        return new MetadataLockKey(EntityKind.DATASET, null, dataverseName, datasetName);
    }

    static MetadataLockKey createDataTypeLockKey(DataverseName dataverseName, String datatypeName) {
        return new MetadataLockKey(EntityKind.DATATYPE, null, dataverseName, datatypeName);
    }

    static MetadataLockKey createFunctionLockKey(DataverseName dataverseName, String functionName) {
        return new MetadataLockKey(EntityKind.FUNCTION, null, dataverseName, functionName);
    }

    static MetadataLockKey createLibraryLockKey(DataverseName dataverseName, String libraryName) {
        return new MetadataLockKey(EntityKind.LIBRARY, null, dataverseName, libraryName);
    }

    static MetadataLockKey createAdapterLockKey(DataverseName dataverseName, String adapterName) {
        return new MetadataLockKey(EntityKind.ADAPTER, null, dataverseName, adapterName);
    }

    static MetadataLockKey createActiveEntityLockKey(DataverseName dataverseName, String entityName) {
        return new MetadataLockKey(EntityKind.ACTIVE, null, dataverseName, entityName);
    }

    static MetadataLockKey createFeedPolicyLockKey(DataverseName dataverseName, String feedPolicyName) {
        return new MetadataLockKey(EntityKind.FEED_POLICY, null, dataverseName, feedPolicyName);
    }

    static MetadataLockKey createSynonymLockKey(DataverseName dataverseName, String synonymName) {
        return new MetadataLockKey(EntityKind.SYNONYM, null, dataverseName, synonymName);
    }

    static MetadataLockKey createExtensionEntityLockKey(String extension, DataverseName dataverseName, String entityName) {
        return new MetadataLockKey(EntityKind.EXTENSION, extension, dataverseName, entityName);
    }

    static MetadataLockKey createNodeGroupLockKey(String nodeGroupName) {
        return new MetadataLockKey(EntityKind.NODE_GROUP, null, null, nodeGroupName);
    }

    static MetadataLockKey createMergePolicyLockKey(String mergePolicyName) {
        return new MetadataLockKey(EntityKind.MERGE_POLICY, null, null, mergePolicyName);
    }

    static enum EntityKind {
        ACTIVE,
        DATASET,
        DATATYPE,
        DATAVERSE,
        EXTENSION,
        FEED_POLICY,
        FUNCTION,
        LIBRARY,
        ADAPTER,
        MERGE_POLICY,
        NODE_GROUP,
        SYNONYM;

    }
}

