/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.Synonym;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public final class SynonymTupleTranslator
extends AbstractTupleTranslator<Synonym> {
    private static final int SYNONYM_PAYLOAD_TUPLE_FIELD_INDEX = 2;

    protected SynonymTupleTranslator(boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.SYNONYM_DATASET, 2);
    }

    @Override
    protected Synonym createMetadataEntityFromARecord(ARecord synonymRecord) {
        String dataverseCanonicalName = ((AString)synonymRecord.getValueByPos(0)).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        String synonymName = ((AString)synonymRecord.getValueByPos(1)).getStringValue();
        String objectDataverseCanonicalName = ((AString)synonymRecord.getValueByPos(2)).getStringValue();
        DataverseName objectDataverseName = DataverseName.createFromCanonicalForm((String)objectDataverseCanonicalName);
        String objectName = ((AString)synonymRecord.getValueByPos(3)).getStringValue();
        return new Synonym(dataverseName, synonymName, objectDataverseName, objectName);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Synonym synonym) throws HyracksDataException {
        String dataverseCanonicalName = synonym.getDataverseName().getCanonicalForm();
        this.tupleBuilder.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(synonym.getSynonymName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.SYNONYM_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(synonym.getSynonymName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(synonym.getObjectDataverseName().getCanonicalForm());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(synonym.getObjectName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

