/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IDataParser;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IStreamDataParser;
import org.apache.asterix.external.parser.AbstractDataParser;
import org.apache.asterix.external.util.ExternalDataConstants;
import org.apache.asterix.external.util.ParseUtil;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParser;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;
import org.apache.hyracks.dataflow.std.file.FieldCursorForDelimitedDataParser;

public class DelimitedDataParser
extends AbstractDataParser
implements IStreamDataParser,
IRecordDataParser<char[]> {
    private final IWarningCollector warnings;
    private final char fieldDelimiter;
    private final char quote;
    private final boolean hasHeader;
    private final ARecordType recordType;
    private final IARecordBuilder recBuilder;
    private final ArrayBackedValueStorage fieldValueBuffer;
    private final DataOutput fieldValueBufferOutput;
    private final IValueParser[] valueParsers;
    private FieldCursorForDelimitedDataParser cursor;
    private Supplier<String> dataSourceName = ExternalDataConstants.EMPTY_STRING;
    private LongSupplier lineNumber = ExternalDataConstants.NO_LINES;
    private final byte[] fieldTypeTags;
    private final int[] fldIds;
    private final ArrayBackedValueStorage[] nameBuffers;
    private final char[] nullChars;

    public DelimitedDataParser(IHyracksTaskContext ctx, IValueParserFactory[] valueParserFactories, char fieldDelimiter, char quote, boolean hasHeader, ARecordType recordType, boolean isStreamParser, String nullString) throws HyracksDataException {
        this.warnings = ctx.getWarningCollector();
        this.fieldDelimiter = fieldDelimiter;
        this.quote = quote;
        this.hasHeader = hasHeader;
        this.recordType = recordType;
        this.valueParsers = new IValueParser[valueParserFactories.length];
        for (int i = 0; i < valueParserFactories.length; ++i) {
            this.valueParsers[i] = valueParserFactories[i].createValueParser();
        }
        this.fieldValueBuffer = new ArrayBackedValueStorage();
        this.fieldValueBufferOutput = this.fieldValueBuffer.getDataOutput();
        this.recBuilder = new RecordBuilder();
        this.recBuilder.reset(recordType);
        this.recBuilder.init();
        int n = recordType.getFieldNames().length;
        this.fieldTypeTags = new byte[n];
        for (int i = 0; i < n; ++i) {
            ATypeTag tag = recordType.getFieldTypes()[i].getTypeTag();
            this.fieldTypeTags[i] = tag.serialize();
        }
        this.fldIds = new int[n];
        this.nameBuffers = new ArrayBackedValueStorage[n];
        AMutableString str = new AMutableString(null);
        for (int i = 0; i < n; ++i) {
            String name = recordType.getFieldNames()[i];
            this.fldIds[i] = this.recBuilder.getFieldId(name);
            if (this.fldIds[i] >= 0) continue;
            if (!recordType.isOpen()) {
                throw new RuntimeDataException(3006, new Serializable[]{name, recordType});
            }
            this.nameBuffers[i] = new ArrayBackedValueStorage();
            str.setValue(name);
            IDataParser.toBytes(str, this.nameBuffers[i], this.stringSerde);
        }
        if (!isStreamParser) {
            this.cursor = new FieldCursorForDelimitedDataParser(null, this.fieldDelimiter, quote, this.warnings, this::getDataSourceName);
        }
        this.nullChars = nullString != null ? nullString.toCharArray() : null;
    }

    @Override
    public boolean parse(DataOutput out) throws HyracksDataException {
        try {
            if (this.cursor.nextRecord()) {
                if (this.parseRecord()) {
                    this.recBuilder.write(out, true);
                    return true;
                }
                throw new RuntimeDataException(3113, new Serializable[0]);
            }
            return false;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private boolean parseRecord() throws HyracksDataException {
        this.recBuilder.reset(this.recordType);
        this.recBuilder.init();
        for (int i = 0; i < this.valueParsers.length; ++i) {
            try {
                FieldCursorForDelimitedDataParser.Result result = this.cursor.nextField();
                switch (result) {
                    case OK: {
                        break;
                    }
                    case END: {
                        if (this.warnings.shouldWarn()) {
                            ParseUtil.warn(this.warnings, this.dataSourceName.get(), this.cursor.getLineCount(), this.cursor.getFieldCount(), "some fields are missing");
                        }
                        return false;
                    }
                    case ERROR: {
                        return false;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                this.fieldValueBuffer.reset();
                if (this.nullChars != null && NonTaggedFormatUtil.isOptional((IAType)this.recordType.getFieldTypes()[i]) && this.fieldNull()) {
                    this.fieldValueBufferOutput.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                } else {
                    boolean success;
                    if (this.cursor.isFieldEmpty() && !DelimitedDataParser.canProcessEmptyField(this.recordType.getFieldTypes()[i])) {
                        if (this.warnings.shouldWarn()) {
                            ParseUtil.warn(this.warnings, this.dataSourceName.get(), this.cursor.getLineCount(), this.cursor.getFieldCount(), "empty value");
                        }
                        return false;
                    }
                    this.fieldValueBufferOutput.writeByte(this.fieldTypeTags[i]);
                    if (this.cursor.fieldHasDoubleQuote()) {
                        this.cursor.eliminateDoubleQuote();
                    }
                    if (!(success = this.valueParsers[i].parse(this.cursor.getBuffer(), this.cursor.getFieldStart(), this.cursor.getFieldLength(), this.fieldValueBufferOutput))) {
                        if (this.warnings.shouldWarn()) {
                            ParseUtil.warn(this.warnings, this.dataSourceName.get(), this.cursor.getLineCount(), this.cursor.getFieldCount(), "invalid value");
                        }
                        return false;
                    }
                }
                if (this.fldIds[i] < 0) {
                    this.recBuilder.addField((IValueReference)this.nameBuffers[i], (IValueReference)this.fieldValueBuffer);
                    continue;
                }
                this.recBuilder.addField(this.fldIds[i], (IValueReference)this.fieldValueBuffer);
                continue;
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        try {
            while (this.cursor.nextField() == FieldCursorForDelimitedDataParser.Result.OK) {
            }
            return true;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public boolean parse(IRawRecord<? extends char[]> record, DataOutput out) throws HyracksDataException {
        this.cursor.nextRecord(record.get(), record.size(), this.lineNumber.getAsLong());
        if (this.parseRecord()) {
            this.recBuilder.write(out, true);
            return true;
        }
        return false;
    }

    @Override
    public void setInputStream(InputStream in) throws IOException {
        this.cursor = new FieldCursorForDelimitedDataParser((Reader)new InputStreamReader(in), this.fieldDelimiter, this.quote, this.warnings, this::getDataSourceName);
        if (this.hasHeader) {
            FieldCursorForDelimitedDataParser.Result result;
            this.cursor.nextRecord();
            while ((result = this.cursor.nextField()) == FieldCursorForDelimitedDataParser.Result.OK) {
            }
            if (result == FieldCursorForDelimitedDataParser.Result.ERROR) {
                throw new RuntimeDataException(3113, new Serializable[0]);
            }
        }
    }

    @Override
    public boolean reset(InputStream in) throws IOException {
        this.cursor = new FieldCursorForDelimitedDataParser((Reader)new InputStreamReader(in), this.fieldDelimiter, this.quote, this.warnings, this::getDataSourceName);
        return true;
    }

    @Override
    public void configure(Supplier<String> dataSourceName, LongSupplier lineNumber) {
        this.dataSourceName = dataSourceName == null ? ExternalDataConstants.EMPTY_STRING : dataSourceName;
        this.lineNumber = lineNumber == null ? ExternalDataConstants.NO_LINES : lineNumber;
    }

    private String getDataSourceName() {
        return this.dataSourceName.get();
    }

    private static boolean canProcessEmptyField(IAType fieldType) {
        IAType type = TypeComputeUtils.getActualType((IAType)fieldType);
        return type.getTypeTag() == ATypeTag.STRING || type.getTypeTag() == ATypeTag.NULL;
    }

    private boolean fieldNull() {
        int nullStringLength;
        int fieldLength = this.cursor.getFieldLength();
        if (fieldLength != (nullStringLength = this.nullChars.length)) {
            return false;
        }
        char[] fieldChars = this.cursor.getBuffer();
        int fieldStart = this.cursor.getFieldStart();
        for (int i = 0; i < fieldLength; ++i) {
            if (fieldChars[fieldStart + i] == this.nullChars[i]) continue;
            return false;
        }
        return true;
    }
}

