/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.ArrayList;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;

public abstract class AbstractBinaryJoinOperator
extends AbstractLogicalOperator {
    protected final Mutable<ILogicalExpression> condition;
    protected JoinKind joinKind;

    public AbstractBinaryJoinOperator(JoinKind joinKind, Mutable<ILogicalExpression> condition) {
        this.joinKind = joinKind;
        this.condition = condition;
    }

    public AbstractBinaryJoinOperator(JoinKind joinKind, Mutable<ILogicalExpression> condition, Mutable<ILogicalOperator> input1, Mutable<ILogicalOperator> input2) {
        this(joinKind, condition);
        this.inputs.add(input1);
        this.inputs.add(input2);
    }

    public Mutable<ILogicalExpression> getCondition() {
        return this.condition;
    }

    public JoinKind getJoinKind() {
        return this.joinKind;
    }

    @Override
    public void recomputeSchema() {
        this.schema = new ArrayList();
        this.schema.addAll(((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue()).getSchema());
        this.schema.addAll(((ILogicalOperator)((Mutable)this.inputs.get(1)).getValue()).getSchema());
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return VariablePropagationPolicy.concat(VariablePropagationPolicy.ALL, VariablePropagationPolicy.ALL);
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform visitor) throws AlgebricksException {
        return visitor.transform(this.condition);
    }

    @Override
    public boolean isMap() {
        return false;
    }

    public static enum JoinKind {
        INNER,
        LEFT_OUTER;

    }
}

