/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.expression;

import java.util.List;
import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.AbstractExpression;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.util.ExpressionUtils;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class WindowExpression
extends AbstractExpression {
    private FunctionSignature functionSignature;
    private List<Expression> exprList;
    private Expression aggFilterExpr;
    private List<Expression> partitionList;
    private List<Expression> orderbyList;
    private List<OrderbyClause.OrderModifier> orderbyModifierList;
    private FrameMode frameMode;
    private FrameBoundaryKind frameStartKind;
    private Expression frameStartExpr;
    private FrameBoundaryKind frameEndKind;
    private Expression frameEndExpr;
    private FrameExclusionKind frameExclusionKind;
    private VariableExpr windowVar;
    private List<Pair<Expression, Identifier>> windowFieldList;
    private Boolean ignoreNulls;
    private Boolean fromLast;

    public WindowExpression(FunctionSignature functionSignature, List<Expression> exprList, Expression aggFilterExpr, List<Expression> partitionList, List<Expression> orderbyList, List<OrderbyClause.OrderModifier> orderbyModifierList, FrameMode frameMode, FrameBoundaryKind frameStartKind, Expression frameStartExpr, FrameBoundaryKind frameEndKind, Expression frameEndExpr, FrameExclusionKind frameExclusionKind, VariableExpr windowVar, List<Pair<Expression, Identifier>> windowFieldList, Boolean ignoreNulls, Boolean fromLast) {
        if (functionSignature == null || exprList == null) {
            throw new NullPointerException();
        }
        this.functionSignature = functionSignature;
        this.exprList = exprList;
        this.aggFilterExpr = aggFilterExpr;
        this.partitionList = partitionList;
        this.orderbyList = orderbyList;
        this.orderbyModifierList = orderbyModifierList;
        this.frameMode = frameMode;
        this.frameStartKind = frameStartKind;
        this.frameStartExpr = frameStartExpr;
        this.frameEndKind = frameEndKind;
        this.frameEndExpr = frameEndExpr;
        this.frameExclusionKind = frameExclusionKind;
        this.windowVar = windowVar;
        this.windowFieldList = windowFieldList;
        this.ignoreNulls = ignoreNulls;
        this.fromLast = fromLast;
    }

    public Expression.Kind getKind() {
        return Expression.Kind.WINDOW_EXPRESSION;
    }

    public FunctionSignature getFunctionSignature() {
        return this.functionSignature;
    }

    public void setFunctionSignature(FunctionSignature functionSignature) {
        if (functionSignature == null) {
            throw new NullPointerException();
        }
        this.functionSignature = functionSignature;
    }

    public List<Expression> getExprList() {
        return this.exprList;
    }

    public void setExprList(List<Expression> exprList) {
        if (exprList == null) {
            throw new NullPointerException();
        }
        this.exprList = exprList;
    }

    public boolean hasAggregateFilterExpr() {
        return this.aggFilterExpr != null;
    }

    public Expression getAggregateFilterExpr() {
        return this.aggFilterExpr;
    }

    public void setAggregateFilterExpr(Expression filterExpr) {
        this.aggFilterExpr = filterExpr;
    }

    public boolean hasPartitionList() {
        return this.partitionList != null && !this.partitionList.isEmpty();
    }

    public List<Expression> getPartitionList() {
        return this.partitionList;
    }

    public void setPartitionList(List<Expression> partitionList) {
        this.partitionList = partitionList;
    }

    public boolean hasOrderByList() {
        return this.orderbyList != null && !this.orderbyList.isEmpty();
    }

    public List<Expression> getOrderbyList() {
        return this.orderbyList;
    }

    public void setOrderbyList(List<Expression> orderbyList) {
        this.orderbyList = orderbyList;
    }

    public List<OrderbyClause.OrderModifier> getOrderbyModifierList() {
        return this.orderbyModifierList;
    }

    public void setOrderbyModifierList(List<OrderbyClause.OrderModifier> orderbyModifierList) {
        this.orderbyModifierList = orderbyModifierList;
    }

    public boolean hasFrameDefinition() {
        return this.frameMode != null;
    }

    public FrameMode getFrameMode() {
        return this.frameMode;
    }

    public void setFrameMode(FrameMode frameMode) {
        this.frameMode = frameMode;
    }

    public FrameBoundaryKind getFrameStartKind() {
        return this.frameStartKind;
    }

    public void setFrameStartKind(FrameBoundaryKind frameStartKind) {
        this.frameStartKind = frameStartKind;
    }

    public boolean hasFrameStartExpr() {
        return this.frameStartExpr != null;
    }

    public Expression getFrameStartExpr() {
        return this.frameStartExpr;
    }

    public void setFrameStartExpr(Expression frameStartExpr) {
        this.frameStartExpr = frameStartExpr;
    }

    public FrameBoundaryKind getFrameEndKind() {
        return this.frameEndKind;
    }

    public void setFrameEndKind(FrameBoundaryKind frameEndKind) {
        this.frameEndKind = frameEndKind;
    }

    public boolean hasFrameEndExpr() {
        return this.frameEndExpr != null;
    }

    public Expression getFrameEndExpr() {
        return this.frameEndExpr;
    }

    public void setFrameEndExpr(Expression frameEndExpr) {
        this.frameEndExpr = frameEndExpr;
    }

    public FrameExclusionKind getFrameExclusionKind() {
        return this.frameExclusionKind;
    }

    public void setFrameExclusionKind(FrameExclusionKind frameExclusionKind) {
        this.frameExclusionKind = frameExclusionKind;
    }

    public boolean hasWindowVar() {
        return this.windowVar != null;
    }

    public VariableExpr getWindowVar() {
        return this.windowVar;
    }

    public void setWindowVar(VariableExpr windowVar) {
        this.windowVar = windowVar;
    }

    public boolean hasWindowFieldList() {
        return this.windowFieldList != null && !this.windowFieldList.isEmpty();
    }

    public List<Pair<Expression, Identifier>> getWindowFieldList() {
        return this.windowFieldList;
    }

    public void setWindowFieldList(List<Pair<Expression, Identifier>> windowFieldList) {
        this.windowFieldList = windowFieldList;
    }

    public Boolean getIgnoreNulls() {
        return this.ignoreNulls;
    }

    public void setIgnoreNulls(Boolean ignoreNulls) {
        this.ignoreNulls = ignoreNulls;
    }

    public Boolean getFromLast() {
        return this.fromLast;
    }

    public void setFromLast(Boolean fromLast) {
        this.fromLast = fromLast;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.functionSignature, this.exprList, this.aggFilterExpr, ExpressionUtils.emptyIfNull(this.partitionList), ExpressionUtils.emptyIfNull(this.orderbyList), ExpressionUtils.emptyIfNull(this.orderbyModifierList), this.frameMode, this.frameStartKind, this.frameStartExpr, this.frameEndKind, this.frameEndExpr, this.frameExclusionKind, this.windowVar, ExpressionUtils.emptyIfNull(this.windowFieldList), this.ignoreNulls, this.fromLast});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WindowExpression)) {
            return false;
        }
        WindowExpression target = (WindowExpression)((Object)object);
        return Objects.equals(this.functionSignature, target.functionSignature) && Objects.equals(this.exprList, target.exprList) && Objects.equals(this.aggFilterExpr, target.aggFilterExpr) && Objects.equals(ExpressionUtils.emptyIfNull(this.partitionList), ExpressionUtils.emptyIfNull(target.partitionList)) && Objects.equals(ExpressionUtils.emptyIfNull(this.orderbyList), ExpressionUtils.emptyIfNull(target.orderbyList)) && Objects.equals(ExpressionUtils.emptyIfNull(this.orderbyModifierList), ExpressionUtils.emptyIfNull(target.orderbyModifierList)) && this.frameMode == target.frameMode && this.frameStartKind == target.frameStartKind && Objects.equals(this.frameStartExpr, target.frameStartExpr) && this.frameEndKind == target.frameEndKind && Objects.equals(this.frameEndExpr, target.frameEndExpr) && this.frameExclusionKind == target.frameExclusionKind && Objects.equals(this.windowVar, target.windowVar) && Objects.equals(ExpressionUtils.emptyIfNull(this.windowFieldList), ExpressionUtils.emptyIfNull(target.windowFieldList)) && Objects.equals(this.ignoreNulls, target.ignoreNulls) && Objects.equals(this.fromLast, target.fromLast);
    }

    public String toString() {
        int i;
        int ln;
        StringBuilder sb = new StringBuilder(128);
        sb.append("WINDOW ");
        sb.append(this.functionSignature);
        sb.append('(');
        sb.append(StringUtils.join(this.exprList, (char)','));
        sb.append(')');
        if (this.fromLast != null && this.fromLast.booleanValue()) {
            sb.append(" FROM LAST");
        }
        if (this.ignoreNulls != null && this.ignoreNulls.booleanValue()) {
            sb.append(" IGNORE NULLS");
        }
        if (this.aggFilterExpr != null) {
            sb.append(" FILTER (WHERE ").append(this.aggFilterExpr).append(')');
        }
        sb.append(" OVER ");
        if (this.hasWindowVar()) {
            sb.append(this.windowVar);
            if (this.hasWindowFieldList()) {
                sb.append('{');
                ln = this.windowFieldList.size();
                for (i = 0; i < ln; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    Pair<Expression, Identifier> p = this.windowFieldList.get(i);
                    sb.append(p.first).append(':').append(p.second);
                }
                sb.append('}');
            }
            sb.append(" AS ");
        }
        sb.append('(');
        if (this.hasPartitionList()) {
            sb.append(" PARTITION BY ");
            sb.append(StringUtils.join(this.partitionList, (char)','));
        }
        if (this.hasOrderByList()) {
            sb.append(" ORDER BY ");
            ln = this.orderbyList.size();
            for (i = 0; i < ln; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.orderbyList.get(i)).append(' ').append(this.orderbyModifierList.get(i));
            }
        }
        if (this.hasFrameDefinition()) {
            sb.append(" FRAME ").append((Object)this.frameMode);
            sb.append(" BETWEEN ").append((Object)this.frameStartKind);
            if (this.hasFrameStartExpr()) {
                sb.append(' ').append(this.frameStartExpr);
            }
            sb.append(" AND ").append((Object)this.frameEndKind);
            if (this.hasFrameEndExpr()) {
                sb.append(' ').append(this.frameEndExpr);
            }
            sb.append(" EXCLUDE ").append((Object)this.frameExclusionKind);
        }
        sb.append(')');
        return sb.toString();
    }

    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return ((ISqlppVisitor)visitor).visit(this, arg);
    }

    public static enum FrameExclusionKind {
        CURRENT_ROW("current row"),
        GROUP("group"),
        TIES("ties"),
        NO_OTHERS("no others");

        private final String text;

        private FrameExclusionKind(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum FrameBoundaryKind {
        CURRENT_ROW("current row"),
        UNBOUNDED_PRECEDING("unbounded preceding"),
        UNBOUNDED_FOLLOWING("unbounded following"),
        BOUNDED_PRECEDING("preceding"),
        BOUNDED_FOLLOWING("following");

        private final String text;

        private FrameBoundaryKind(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum FrameMode {
        RANGE("range"),
        ROWS("rows"),
        GROUPS("groups");

        private final String text;

        private FrameMode(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

