/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class SimpleUnnestToProductRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (!this.isScanOrUnnest(op)) {
            return false;
        }
        Mutable opRef2 = (Mutable)op.getInputs().get(0);
        ILogicalOperator op2 = (ILogicalOperator)opRef2.getValue();
        if (!this.isScanOrUnnest(op2) && !this.descOrSelfIsSourceScan(op2)) {
            return false;
        }
        if (!this.opsAreIndependent(op, op2)) {
            return false;
        }
        Mutable currentOpRef = opRef;
        Mutable boundaryOpRef = (Mutable)((ILogicalOperator)currentOpRef.getValue()).getInputs().get(0);
        while (((ILogicalOperator)currentOpRef.getValue()).getInputs().size() == 1) {
            currentOpRef = (Mutable)((ILogicalOperator)currentOpRef.getValue()).getInputs().get(0);
        }
        Mutable tupleSourceOpRef = currentOpRef;
        currentOpRef = opRef;
        if (((ILogicalOperator)tupleSourceOpRef.getValue()).getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
            while (((ILogicalOperator)currentOpRef.getValue()).getInputs().size() == 1 && ((ILogicalOperator)currentOpRef.getValue()).getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN && this.descOrSelfIsSourceScan((ILogicalOperator)currentOpRef.getValue()) && this.opsAreIndependent((ILogicalOperator)currentOpRef.getValue(), (ILogicalOperator)tupleSourceOpRef.getValue())) {
                boundaryOpRef = (Mutable)((ILogicalOperator)currentOpRef.getValue()).getInputs().get(0);
                currentOpRef = (Mutable)((ILogicalOperator)currentOpRef.getValue()).getInputs().get(0);
            }
        } else {
            boundaryOpRef = (Mutable)((ILogicalOperator)opRef.getValue()).getInputs().get(0);
            while (((ILogicalOperator)boundaryOpRef.getValue()).getInputs().size() == 1 && ((ILogicalOperator)boundaryOpRef.getValue()).getOperatorTag() != LogicalOperatorTag.DATASOURCESCAN) {
                ArrayList opUsedVars = new ArrayList();
                VariableUtilities.getUsedVariables((ILogicalOperator)((ILogicalOperator)boundaryOpRef.getValue()), opUsedVars);
                if (opUsedVars.size() == 0 && OperatorPropertiesUtil.isMovable((ILogicalOperator)((ILogicalOperator)boundaryOpRef.getValue()))) {
                    boundaryOpRef = (Mutable)((ILogicalOperator)boundaryOpRef.getValue()).getInputs().get(0);
                    continue;
                }
                break;
            }
        }
        ILogicalOperator innerBranchOperator = (ILogicalOperator)opRef.getValue();
        ILogicalOperator boundaryOperator = (ILogicalOperator)boundaryOpRef.getValue();
        if (OperatorPropertiesUtil.isCardinalityZeroOrOne((ILogicalOperator)boundaryOperator) && !this.descOrSelfIsLeafSourceScan(innerBranchOperator, boundaryOperator)) {
            return false;
        }
        InnerJoinOperator join = new InnerJoinOperator((Mutable)new MutableObject((Object)ConstantExpression.TRUE), (Mutable)new MutableObject((Object)boundaryOperator), (Mutable)new MutableObject((Object)innerBranchOperator));
        opRef.setValue((Object)join);
        EmptyTupleSourceOperator ets = new EmptyTupleSourceOperator();
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)ets);
        boundaryOpRef.setValue((Object)ets);
        context.computeAndSetTypeEnvironmentForOperator(boundaryOperator);
        context.computeAndSetTypeEnvironmentForOperator(innerBranchOperator);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)join);
        return true;
    }

    private boolean descOrSelfIsSourceScan(ILogicalOperator op) {
        if (op.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
            return true;
        }
        for (Mutable cRef : op.getInputs()) {
            if (!this.descOrSelfIsSourceScan((ILogicalOperator)cRef.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean descOrSelfIsLeafSourceScan(ILogicalOperator op, ILogicalOperator bottomOp) {
        if (op == bottomOp) {
            return false;
        }
        if (op.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
            DataSourceScanOperator dataSourceScanOperator = (DataSourceScanOperator)op;
            return dataSourceScanOperator.getDataSource().isScanAccessPathALeaf();
        }
        for (Mutable cRef : op.getInputs()) {
            if (!this.descOrSelfIsLeafSourceScan((ILogicalOperator)cRef.getValue(), bottomOp)) continue;
            return true;
        }
        return false;
    }

    private boolean opsAreIndependent(ILogicalOperator unnestOp, ILogicalOperator outer) throws AlgebricksException {
        if (unnestOp.equals(outer)) {
            return false;
        }
        ArrayList opUsedVars = new ArrayList();
        VariableUtilities.getUsedVariables((ILogicalOperator)unnestOp, opUsedVars);
        HashSet op2LiveVars = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)outer, op2LiveVars);
        for (LogicalVariable usedVar : opUsedVars) {
            if (!op2LiveVars.contains(usedVar)) continue;
            return false;
        }
        return true;
    }

    private boolean isScanOrUnnest(ILogicalOperator op) {
        LogicalOperatorTag opTag = op.getOperatorTag();
        return opTag == LogicalOperatorTag.DATASOURCESCAN || opTag == LogicalOperatorTag.UNNEST;
    }
}

