/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;

public abstract class BuiltinType
implements IAType {
    private static final long serialVersionUID = 1L;
    private static final String TAG_FIELD = "tag";
    public static final BuiltinType ALL_TYPE = new BuiltinType(){
        private static final long serialVersionUID = 1L;

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.TYPE;
        }

        @Override
        public String getDisplayName() {
            return "AllType";
        }

        @Override
        public String getTypeName() {
            return "ALL_TYPE";
        }

        @Override
        public String getConstructor() {
            return null;
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "ALL_TYPE");
            return type;
        }
    };
    public static final BuiltinType AINT8 = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "AInt8";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.TINYINT;
        }

        @Override
        public String getTypeName() {
            return "int8";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "AInt8");
            return type;
        }
    };
    public static final BuiltinType AINT16 = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "AInt16";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.SMALLINT;
        }

        @Override
        public String getTypeName() {
            return "int16";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "AInt16");
            return type;
        }
    };
    public static final BuiltinType AINT32 = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "AInt32";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.INTEGER;
        }

        @Override
        public String getTypeName() {
            return "int32";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "AInt32");
            return type;
        }
    };
    public static final BuiltinType AINT64 = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.BIGINT;
        }

        @Override
        public String getDisplayName() {
            return "AInt64";
        }

        @Override
        public String getTypeName() {
            return "int64";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "AInt64");
            return type;
        }
    };
    public static final BuiltinType ABINARY = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "ABinary";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.BINARY;
        }

        @Override
        public String getTypeName() {
            return "binary";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "ABinary");
            return type;
        }
    };
    public static final BuiltinType AFLOAT = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "AFloat";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.FLOAT;
        }

        @Override
        public String getTypeName() {
            return "float";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "AFloat");
            return type;
        }
    };
    public static final BuiltinType ADOUBLE = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "ADouble";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.DOUBLE;
        }

        @Override
        public String getTypeName() {
            return "double";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "ADouble");
            return type;
        }
    };
    public static final BuiltinType ASTRING = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "AString";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.STRING;
        }

        @Override
        public String getTypeName() {
            return "string";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "AString");
            return type;
        }
    };
    public static final BuiltinType AMISSING = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "Missing";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.MISSING;
        }

        @Override
        public String getTypeName() {
            return "missing";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "AMISSING");
            return type;
        }
    };
    public static final BuiltinType ANULL = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "Null";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.NULL;
        }

        @Override
        public String getTypeName() {
            return "null";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "ANULL");
            return type;
        }
    };
    public static final BuiltinType ABOOLEAN = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "ABoolean";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.BOOLEAN;
        }

        @Override
        public String getTypeName() {
            return "boolean";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "ABoolean");
            return type;
        }
    };
    public static final BuiltinType ATIME = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "ATime";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.TIME;
        }

        @Override
        public String getTypeName() {
            return "time";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "ATime");
            return type;
        }
    };
    public static final BuiltinType ADATE = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "ADate";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.DATE;
        }

        @Override
        public String getTypeName() {
            return "date";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "ADate");
            return type;
        }
    };
    public static final BuiltinType ADATETIME = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "ADateTime";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.DATETIME;
        }

        @Override
        public String getTypeName() {
            return "datetime";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "ADateTime");
            return type;
        }
    };
    public static final BuiltinType ADURATION = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "ADuration";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.DURATION;
        }

        @Override
        public String getTypeName() {
            return "duration";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "ADuration");
            return type;
        }
    };
    public static final BuiltinType AYEARMONTHDURATION = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "AYearMonthDuration";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.YEARMONTHDURATION;
        }

        @Override
        public String getTypeName() {
            return "year-month-duration";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "AYearMonthDuration");
            return type;
        }
    };
    public static final BuiltinType ADAYTIMEDURATION = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "ADayTimeDuration";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.DAYTIMEDURATION;
        }

        @Override
        public String getTypeName() {
            return "day-time-duration";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "ADayTimeDuration");
            return type;
        }
    };
    public static final BuiltinType AINTERVAL = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "AInterval";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.INTERVAL;
        }

        @Override
        public String getTypeName() {
            return "interval";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            return null;
        }
    };
    public static final BuiltinType APOINT = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.POINT;
        }

        @Override
        public String getDisplayName() {
            return "APoint";
        }

        @Override
        public String getTypeName() {
            return "point";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "APoint");
            return type;
        }
    };
    public static final BuiltinType APOINT3D = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.POINT3D;
        }

        @Override
        public String getDisplayName() {
            return "APoint3D";
        }

        @Override
        public String getTypeName() {
            return "point3d";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "APoint3D");
            return type;
        }
    };
    public static final BuiltinType ALINE = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "ALINE";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.LINE;
        }

        @Override
        public String getTypeName() {
            return "line";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "ALINE");
            return type;
        }
    };
    public static final BuiltinType APOLYGON = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "APOLYGON";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.POLYGON;
        }

        @Override
        public String getTypeName() {
            return "polygon";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "APOLYGON");
            return type;
        }
    };
    public static final BuiltinType AGEOMETRY = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "AGEOMETRY";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.GEOMETRY;
        }

        @Override
        public String getTypeName() {
            return "geometry";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectNode type = new ObjectMapper().createObjectNode();
            type.put("type", "AGEOMETRY");
            return type;
        }
    };
    public static final BuiltinType ACIRCLE = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "ACIRCLE";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.CIRCLE;
        }

        @Override
        public String getTypeName() {
            return "circle";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "ACIRCLE");
            return type;
        }
    };
    public static final BuiltinType ARECTANGLE = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getDisplayName() {
            return "ARECTANGLE";
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.RECTANGLE;
        }

        @Override
        public String getTypeName() {
            return "rectangle";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "ARECTANGLE");
            return type;
        }
    };
    public static final IAType ABITARRAY = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.BITARRAY;
        }

        @Override
        public String getDisplayName() {
            return "ABitArray";
        }

        @Override
        public String getTypeName() {
            return "abitarray";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "ABitArray");
            return type;
        }
    };
    public static final BuiltinType AUUID = new LowerCaseConstructorType(){
        private static final long serialVersionUID = 1L;

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.UUID;
        }

        @Override
        public String getDisplayName() {
            return "UUID";
        }

        @Override
        public String getTypeName() {
            return "uuid";
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", this.getDisplayName());
            return type;
        }
    };
    public static final BuiltinType ANY = new BuiltinType(){
        private static final long serialVersionUID = 1L;

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.ANY;
        }

        @Override
        public String getTypeName() {
            return "any";
        }

        @Override
        public String getDisplayName() {
            return "ANY";
        }

        @Override
        public String getConstructor() {
            return null;
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "ANY");
            return type;
        }
    };
    public static final BuiltinType SHORTWITHOUTTYPEINFO = new BuiltinType(){
        private static final long serialVersionUID = 1L;

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.SHORTWITHOUTTYPEINFO;
        }

        @Override
        public String getTypeName() {
            return "shortwithouttypeinfo";
        }

        @Override
        public String getDisplayName() {
            return "SHORTWITHOUTTYPEINFO";
        }

        @Override
        public String getConstructor() {
            return null;
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) {
            return BuiltinType.convertToJson(registry, this.getTypeTag().serialize(), 1L);
        }

        public ObjectNode toJSON() {
            ObjectMapper om = new ObjectMapper();
            ObjectNode type = om.createObjectNode();
            type.put("type", "SHORTWITHOUTTYPEINFO");
            return type;
        }
    };

    public abstract String getConstructor();

    @Override
    public IAType getType() {
        return ALL_TYPE;
    }

    public String toString() {
        return this.getTypeTag().toString();
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BuiltinType)) {
            return false;
        }
        return ((BuiltinType)obj).getTypeTag().equals(this.getTypeTag());
    }

    public boolean equals(Object object) {
        return object instanceof IAObject && this.deepEqual((IAObject)object);
    }

    public int hashCode() {
        return this.getTypeTag().hashCode();
    }

    @Override
    public int hash() {
        return this.getType().getTypeTag().serialize();
    }

    private static JsonNode convertToJson(IPersistedResourceRegistry registry, short tag, long version) {
        ObjectNode jsonNode = registry.getClassIdentifier(BuiltinType.class, version);
        jsonNode.put(TAG_FIELD, tag);
        return jsonNode;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
        byte tag = (byte)json.get(TAG_FIELD).shortValue();
        ATypeTag typeTag = ATypeTag.VALUE_TYPE_MAPPING[tag];
        switch (typeTag) {
            case TYPE: {
                return ALL_TYPE;
            }
            case TINYINT: {
                return AINT8;
            }
            case SMALLINT: {
                return AINT16;
            }
            case INTEGER: {
                return AINT32;
            }
            case BIGINT: {
                return AINT64;
            }
            case FLOAT: {
                return AFLOAT;
            }
            case DOUBLE: {
                return ADOUBLE;
            }
            case STRING: {
                return ASTRING;
            }
            case BINARY: {
                return ABINARY;
            }
            case MISSING: {
                return AMISSING;
            }
            case NULL: {
                return ANULL;
            }
            case BOOLEAN: {
                return ABOOLEAN;
            }
            case TIME: {
                return ATIME;
            }
            case DATE: {
                return ADATE;
            }
            case DATETIME: {
                return ADATETIME;
            }
            case DURATION: {
                return ADURATION;
            }
            case YEARMONTHDURATION: {
                return AYEARMONTHDURATION;
            }
            case DAYTIMEDURATION: {
                return ADAYTIMEDURATION;
            }
            case INTERVAL: {
                return AINTERVAL;
            }
            case POINT: {
                return APOINT;
            }
            case POINT3D: {
                return APOINT3D;
            }
            case LINE: {
                return ALINE;
            }
            case POLYGON: {
                return APOLYGON;
            }
            case GEOMETRY: {
                return AGEOMETRY;
            }
            case CIRCLE: {
                return ACIRCLE;
            }
            case RECTANGLE: {
                return ARECTANGLE;
            }
            case BITARRAY: {
                return ABITARRAY;
            }
            case UUID: {
                return AUUID;
            }
            case ANY: {
                return ANY;
            }
            case SHORTWITHOUTTYPEINFO: {
                return SHORTWITHOUTTYPEINFO;
            }
        }
        throw new UnsupportedOperationException(typeTag.toString());
    }

    public static abstract class LowerCaseConstructorType
    extends BuiltinType {
        private static final long serialVersionUID = 1L;

        @Override
        public String getConstructor() {
            return this.getTypeTag().toString().toLowerCase();
        }
    }
}

