/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.om.base.ACollectionCursor;
import org.apache.asterix.om.base.IACollection;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.base.InMemUtils;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.IAType;

public class AUnorderedList
implements IACollection {
    protected List<IAObject> values;
    protected AUnorderedListType type;

    public AUnorderedList(AUnorderedListType type) {
        this.values = new ArrayList<IAObject>();
        this.type = type;
    }

    public AUnorderedList(AUnorderedListType type, List<IAObject> sequence) {
        this.values = sequence;
        this.type = type;
    }

    @Override
    public IACursor getCursor() {
        ACollectionCursor cursor = new ACollectionCursor();
        cursor.reset(this);
        return cursor;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AUnorderedList)) {
            return false;
        }
        AUnorderedList y = (AUnorderedList)o;
        return InMemUtils.cursorEquals(this.getCursor(), y.getCursor());
    }

    public int hashCode() {
        return InMemUtils.hashCursor(this.getCursor());
    }

    @Override
    public IAType getType() {
        return this.type;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        return this.equals(obj);
    }

    @Override
    public int hash() {
        return this.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("multiset: {{ ");
        boolean first = true;
        for (IAObject v : this.values) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(v.toString());
        }
        sb.append(" }}");
        return sb.toString();
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        ArrayNode list = om.createArrayNode();
        for (IAObject v : this.values) {
            list.add((JsonNode)v.toJSON());
        }
        json.set("AUnorderedList", (JsonNode)list);
        return json;
    }
}

