/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.definition;

import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.definition.ThemesExtensionElement;
import org.eclipse.e4.ui.css.swt.helpers.ThemeElementDefinitionHelper;
import org.eclipse.e4.ui.internal.css.swt.definition.IThemesExtension;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyThemesExtensionHandler
implements ICSSPropertyHandler {
    private static final String DEFINITION_LIST_SEPARATOR = ",";
    private static final String FONT_DEFINITION_PROP = "font-definition";
    private static final String COLOR_DEFINITION_PROP = "color-definition";

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!(element instanceof ThemesExtensionElement) || property == null) {
            return false;
        }
        IThemesExtension themeExtension = (IThemesExtension)((ThemesExtensionElement)((Object)element)).getNativeWidget();
        switch (property) {
            case "font-definition": {
                this.addDefinitions(themeExtension, true, this.parseSymbolicNames(value.getCssText()));
                break;
            }
            case "color-definition": {
                this.addDefinitions(themeExtension, false, this.parseSymbolicNames(value.getCssText()));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    private String[] parseSymbolicNames(String symbolicNames) {
        return symbolicNames.split(DEFINITION_LIST_SEPARATOR);
    }

    private void addDefinitions(IThemesExtension themeExtension, boolean fontDefinitions, String ... symbolicNames) {
        String[] stringArray = symbolicNames;
        int n = symbolicNames.length;
        int n2 = 0;
        while (n2 < n) {
            String symbolicName = stringArray[n2];
            String normalizedSymbolicName = ThemeElementDefinitionHelper.normalizeId(symbolicName.trim().substring(1));
            if (fontDefinitions) {
                themeExtension.addFontDefinition(normalizedSymbolicName);
            } else {
                themeExtension.addColorDefinition(normalizedSymbolicName);
            }
            ++n2;
        }
    }
}

