/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.secret;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionSecretKeeper;
import org.jkiss.dbeaver.model.secret.DBSSecretObject;
import org.jkiss.dbeaver.model.secret.DBSSecretValue;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public interface DBSSecretController {
    public static final long FEATURE_PRIVATE_SECRETS_VIEW = 1L;
    public static final long FEATURE_PRIVATE_SECRETS_EDIT = 2L;
    public static final long FEATURE_SHARED_SECRETS_VIEW = 4L;
    public static final long FEATURE_SHARED_SECRETS_EDIT = 8L;

    default public long getSupportedFeatures() throws DBException {
        return 15L;
    }

    @Nullable
    public String getPrivateSecretValue(@NotNull String var1) throws DBException;

    public void setPrivateSecretValue(@NotNull String var1, @Nullable String var2) throws DBException;

    default public void setPrivateSecretValue(@NotNull DBSSecretObject secretObject, @NotNull DBSSecretValue secretValue) throws DBException {
        this.setPrivateSecretValue(secretValue.getId(), secretValue.getValue());
    }

    @NotNull
    public List<DBSSecretValue> discoverCurrentUserSecrets(@NotNull DBSSecretObject var1) throws DBException;

    @NotNull
    default public List<DBSSecretValue> listAllSharedSecrets(@NotNull DBSSecretObject secretObject) throws DBException {
        return List.of();
    }

    default public void setSubjectSecretValue(@NotNull String subjectId, @NotNull DBSSecretObject secretObject, @NotNull DBSSecretValue secretValue) throws DBException {
    }

    default public void deleteSubjectSecrets(@NotNull String subjectId) throws DBException {
    }

    default public void deleteProjectSecrets(@NotNull String projectId) throws DBException {
    }

    default public void deleteObjectSecrets(@NotNull DBSSecretObject secretObject) throws DBException {
    }

    public void flushChanges() throws DBException;

    @NotNull
    public static DBSSecretController getProjectSecretController(DBPProject project) throws DBException {
        return DBSSecretController.getSessionSecretController(project.getWorkspaceSession());
    }

    @NotNull
    public static DBSSecretController getGlobalSecretController() throws DBException {
        return DBSSecretController.getSessionSecretController(DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession());
    }

    @NotNull
    public static DBSSecretController getSessionSecretController(SMSession spaceSession) throws DBException {
        DBSSecretController secretController = DBSSecretController.getSessionSecretControllerOrNull(spaceSession);
        if (secretController != null) {
            return secretController;
        }
        throw new DBException("Session secret controller not found");
    }

    @Nullable
    public static DBSSecretController getSessionSecretControllerOrNull(SMSession spaceSession) throws DBException {
        SMSessionSecretKeeper secretKeeper = DBUtils.getAdapter(SMSessionSecretKeeper.class, spaceSession);
        if (secretKeeper != null) {
            return secretKeeper.getSecretController();
        }
        return null;
    }
}

