# Minimal JWT wrapper which only decodes the base64 header/claim values,
# and doesn't encode/validate JWT tokens.
#
# Note that swapping this out for a third-party gem will work, but
# there may be potential security issues with the key id (kid) claim etc,
# which would need to be reviewed.
class Msf::Exploit::Remote::HTTP::JWT
  attr_reader :payload, :header, :signature

  def initialize(payload:, header:, signature:)
    @payload = payload
    @header = header
    @signature = signature
  end

  def self.encode(payload, key, algorithm = 'HS256', header_fields = {})
    raise NotImplementedError
  end

  def self.decode(jwt, _key = nil, _verify = true, _options = {})
    header, payload, signature = jwt.split('.', 3)
    raise ArgumentError, 'Invalid JWT format' if header.nil? || payload.nil? || signature.nil?

    header = JSON.parse(Rex::Text.decode_base64(header))
    payload = JSON.parse(Rex::Text.decode_base64(payload))

    self.new(payload: payload, header: header, signature: signature)
  end
end
