/*----------------------------------------------------------------------------

   libtunepimp -- The MusicBrainz tagging library.
                  Let a thousand taggers bloom!

   Copyright (C) Robert Kaye 2003

   This file is part of libtunepimp.

   libtunepimp is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   libtunepimp is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with libtunepimp; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   $Id: context.h 7530 2006-05-12 01:29:04Z luks $

----------------------------------------------------------------------------*/
#ifndef CONTEXT_H
#define CONTEXT_H

#include "defs.h"

class TunePimp;

class Context
{
    public:

                 Context(void)
                   {
#if WIN32
                       fileMask = "%sortname\\%album\\%sortname-%album-%0num-%track";
                       variousFileMask = "Various Artists\\%album\\%album-%0num-%artist-%track";
                       nonAlbumFileMask = "%sortname\\%album\\%sortname-%track";
#else
                       fileMask = "%artist/%album/%artist-%album-%0num-%track";
                       variousFileMask = "Various Artists/%album/%album-%0num-%artist-%track";
                       nonAlbumFileMask = "%artist/%album/%artist-%track";
#endif
                       allowedFileCharacters = ""; // Allow all as per filesystem
                       destDir = "MyMusic";
                       topSrcDir = ".";
                       renameFiles = true;
                       moveFiles = true;
                       writeID3v1 = true;
                       autoSaveThreshold = 90;
                       debug = false;
                       clearTags = false;
                       winSafeFileNames = false;
                       pimp = NULL;
                       analyzerPriority = eNormal;
                       autoRemoveSavedFiles = false;
                       maxFileNameLen = -1;
                       writeID3v2_3 = false;
                       id3Encoding = eUTF8;
                       fileNameEncoding = "UTF-8";
                       clientId = "";
                   };

        virtual  ~Context(void) {};

        void      setDestDir (const string &destDir)
                    { this->destDir = destDir; };
        string   &getDestDir (void)
                    { return destDir; };
                
        void      setTopSrcDir (const string &topSrcDir)
                    { this->topSrcDir = topSrcDir; };
        string   &getTopSrcDir (void)
                    { return topSrcDir; };
                
        void      setFileMask (const string &fileMask)
                    { this->fileMask = fileMask; };
        string   &getFileMask (void)
                    { return fileMask; };
                
        void      setVariousFileMask (const string &variousFileMask)
                    { this->variousFileMask = variousFileMask; };
        string   &getVariousFileMask (void)
                    { return variousFileMask; };

        void      setNonAlbumFileMask (const string &nonAlbumFileMask)
                    { this->nonAlbumFileMask = nonAlbumFileMask; };
        string   &getNonAlbumFileMask (void)
                    { return nonAlbumFileMask; };
                
        void      setAllowedFileCharacters (const string &allowedFileCharacters)
                    { this->allowedFileCharacters = allowedFileCharacters; };
        string   &getAllowedFileCharacters (void)
                    { return allowedFileCharacters; };
                
        void      setWinSafeFileNames (bool winSafeFileNames)
                    { this->winSafeFileNames = winSafeFileNames; };
        bool      getWinSafeFileNames (void)
                    { return winSafeFileNames; };
                
        void      setRenameFiles (bool renameFiles)
                    { this->renameFiles = renameFiles; };
        bool      getRenameFiles (void)
                    { return renameFiles; };
                
        void      setMoveFiles (bool moveFiles)
                    { this->moveFiles = moveFiles; };
        bool      getMoveFiles (void)
                    { return moveFiles; };
                
        void      setWriteID3v1 (bool writeID3v1)
                    { this->writeID3v1 = writeID3v1; };
        bool      getWriteID3v1 (void)
                    { return writeID3v1; };
                
        void      setWriteID3v2_3 (bool writeID3v2_3)
                    { this->writeID3v2_3 = writeID3v2_3; };
        bool      getWriteID3v2_3 (void)
                    { return writeID3v2_3; };

        void      setID3Encoding (TPID3Encoding enc)
                    { this->id3Encoding = enc; };
        TPID3Encoding getID3Encoding (void)
                    { return id3Encoding; };
                
        void      setDebug (bool debug)
                    { this->debug = debug; };
        bool      getDebug (void)
                    { return debug; };
                
        void      setAutoSaveThreshold (int autoSaveThreshold)
                    { this->autoSaveThreshold = autoSaveThreshold; };
        int       getAutoSaveThreshold (void)
                    { return autoSaveThreshold; };
                
        void      setClearTags (bool clearTags)
                    { this->clearTags = clearTags; };
        bool      getClearTags (void)
                    { return clearTags; };
                
        void      setTunePimp (TunePimp *pimp)
                    { this->pimp = pimp; };
        TunePimp *getTunePimp (void)
                    { return pimp; };

        void      setAnalyzerPriority (TPThreadPriorityEnum pri)
                    { analyzerPriority = pri; }
        TPThreadPriorityEnum getAnalyzerPriority (void)
                    { return analyzerPriority; };

        void      setFileNameEncoding (const string &encoding)
                    { fileNameEncoding = encoding; };
        string   &getFileNameEncoding (void)
                    { return fileNameEncoding; };
                
        void      setMaxFileNameLen (int maxFileNameLen)
                    { this->maxFileNameLen = maxFileNameLen; };
        int       getMaxFileNameLen (void)
                    { return maxFileNameLen; };
                
        void      setAutoRemoveSavedFiles (bool autoRemoveSavedFiles)
                    { this->autoRemoveSavedFiles = autoRemoveSavedFiles; };
        bool      getAutoRemoveSavedFiles (void)
                    { return autoRemoveSavedFiles; };
                
        void      setMusicDNSClientId(const string &clientId)
                    { this->clientId = clientId; }

        string   &getMusicDNSClientId(void)
                    { return this->clientId; }

    private:

        string                fileMask, variousFileMask, 
                              nonAlbumFileMask, destDir, clientId,
                              topSrcDir, allowedFileCharacters, fileNameEncoding;
        bool                  moveFiles, renameFiles, debug, winSafeFileNames;
        bool                  writeID3v1, clearTags, autoRemoveSavedFiles, writeID3v2_3;
        int                   puidThreshold, autoSaveThreshold, minThreshold, maxFileNameLen;
        TPID3Encoding         id3Encoding;
        TunePimp             *pimp;
        TPThreadPriorityEnum  analyzerPriority;
};

#endif
