/* (PD) 2001 The Bitzi Corporation
 * Please see file COPYING or http://bitzi.com/publicdomain 
 * for more info.
 *
 * $Id: list.c,v 1.2 2001/09/10 22:26:19 robert Exp $
 */
/*------------------------------------------------------------------------- */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "list.h"

/*------------------------------------------------------------------------- */
#define DEFAULT_NUM_ITEMS 16
#define GROW_NUM_ITEMS    16
/*------------------------------------------------------------------------- */

List *create_list(void)
{
    List *list;

    list = malloc(sizeof(List));
    memset(list, 0, sizeof(List));

    return list;
}

int num_items_in_list(List *list)
{
    return list->numItems;
}

void add_to_list(List *list, void *node)
{
    /* Check to see if the attr list already exists */
    if (list->list == NULL)
    {
        list->list = (void **)malloc(sizeof(void *) * DEFAULT_NUM_ITEMS);
        memset(list->list, 0, sizeof(void *) * DEFAULT_NUM_ITEMS);
        list->numItems = 0;
        list->numAllocated = DEFAULT_NUM_ITEMS;
    }

    /* Do we have enough space for another item? If not, grow the array */
    if (list->numItems == list->numAllocated)
    {
        list->numAllocated += GROW_NUM_ITEMS;
        list->list = (void **)realloc(list->list, sizeof(void *) * 
                                      list->numAllocated);
        memset(&list->list[list->numItems], 
               0, sizeof(void *) * GROW_NUM_ITEMS);
    }

    list->list[list->numItems] = node;
    list->numItems++;
}

void *return_item(List *list, int index)
{
    if (index >= list->numItems)
       return NULL;  

    return list->list[index];
}

void delete_list(List *list)
{
    free(list->list);
    free(list);
}

