#include <Python.h>
#include "pymusicbrainz.h"

extern PyTypeObject py_mb_type;


static PyObject * Py_MusicBrainzError;

static char docstring[] = "\
Search and submit data to the MusicBrainz database\n\
\n\
The MusicBrainz client library serves as a tool to allow developers to\n\
integrate MusicBrainz searches and metadata exchange functionality into\n\
their applications.\n\
\n\
The client library includes the following features: \n\
\n\
 * Lookup Audio CD metadata using CD Index diskids \n\
 * Calculate Relatable TRM acoustic fingerprints \n\
 * Search for artist/album/track titles \n\
 * Lookup metadata by name, TRM ids or MusicBrainz Ids \n\
\n\
See http://mm.musicbrainz.org/client_howto.html for more info\n\
";

static char mb_docstring[] = "\
Create an musicbrainz object.\n\
";

static char trm_docstring[] = "\
Create an trm object.\n\
";

static PyMethodDef MusicBrainz_methods[] = {
  {"mb",  (PyCFunction) py_mb_new,  METH_VARARGS, mb_docstring},
  {"trm", (PyCFunction) py_trm_new, METH_VARARGS, trm_docstring},
  {NULL, NULL}
};

void * 
py_mb_raise_exception(const char * format, ...)
{
    char exceptionMsg[1024];
    va_list ap;
    
    va_start(ap, format);
    vsnprintf(exceptionMsg, 1024, format, ap);
    va_end(ap);
    PyErr_SetString(Py_MusicBrainzError, exceptionMsg);
    return NULL;
}

void 
init_musicbrainz(void)
{
  PyObject *module, *dict;

  module = Py_InitModule3("_musicbrainz", MusicBrainz_methods, docstring);
  dict = PyModule_GetDict(module);
  
  Py_MusicBrainzError = PyErr_NewException("musicbrainz.MusicBrainzError",
              NULL, NULL);
  PyDict_SetItemString(dict, "MusicBrainzError",
           Py_MusicBrainzError);

  PyDict_SetItemString(dict, "__version__", 
           PyString_FromString(VERSION));

  if (PyErr_Occurred())
    PyErr_SetString(PyExc_ImportError,
        "musicbrainz: init failed");
}
