#!/usr/bin/env python

import sys
import musicbrainz
from musicbrainz.queries import *

def main():
    mb = musicbrainz.mb()
    mb.UseUTF8(1)
    mb.SetDepth(4)
    mb.SetDebug(0)
    
    mb.QueryWithArgs(MBQ_GetAlbumById, ['01141733-ea65-4ca7-87fc-81ae3ca72d59'])
    #rdf = mb.GetResultRDF()
    #print rdf.encode('latin1')
    print "no. of albums:", mb.GetResultInt(MBE_GetNumAlbums)
    for ii in xrange(1, mb.GetResultInt(MBE_GetNumAlbums)+1):
        mb.Select1(MBS_SelectAlbum, ii)
        print "Yes and here's the info:"
        album = mb.GetResultData(MBE_AlbumGetAlbumName)
        artistId = mb.GetIDFromURL(mb.GetResultData(MBE_AlbumGetAlbumArtistId))
        if artistId == MBI_VARIOUS_ARTIST_ID:
            print "\t%s" % album
        else:    
            artist = mb.GetResultData1(MBE_AlbumGetArtistName, 1)
            print "\t%s / %s" % (artist.encode('latin1'), album.encode('latin1'))
        
        for ii in range(1, mb.GetResultInt(MBE_AlbumGetNumTracks) + 1):
            trackURI = mb.GetResultData1(MBE_AlbumGetTrackId, ii)
            trackId = mb.GetIDFromURL(trackURI)
            name = mb.GetResultData1(MBE_AlbumGetTrackName, ii)
            track = mb.GetOrdinalFromList(MBE_AlbumGetTrackList, trackURI)
            dura = mb.GetResultInt1(MBE_AlbumGetTrackDuration, ii)
            mbdura = "%d:%02d" % divmod(int(dura / 1000), 60)
            if artistId == MBI_VARIOUS_ARTIST_ID:
                artist = mb.GetResultData1(MBE_AlbumGetArtistName, ii)
                print "\t%02d - %s - %s (%s)" % (track, artist, name, mbdura) 
            else:
                print "\t%02d - %s (%s)" % (track, name, mbdura) 
        

if __name__ == '__main__':
    main()
