#!/usr/bin/env python

import sys
import musicbrainz
from musicbrainz.queries import *
import difflib

def main():
    artist = 'Violent Femmes'
    album = ''
    track = "Country Death Song"

    mb = musicbrainz.mb()
    
    #mb.SetServer("musicbrainz", 80)
    mb.UseUTF8(0)
    mb.SetDepth(2)

    artistlist = []
    albumlist = []
    
    mb.QueryWithArgs(MBQ_FindArtistByName, [artist])
    print mb.GetResultRDF()
    numArtists = mb.GetResultInt(MBE_GetNumArtists)
    if numArtists < 1:
        print "No artists found."
    for ii in range(1, numArtists+1):
        mb.Select(MBS_Rewind)  
        mb.Select1(MBS_SelectArtist, ii)  
        artistlist.append(mb.GetResultData(MBE_ArtistGetArtistName))
    print artistlist
    artist = difflib.get_close_matches(artist, artistlist, 1)[0]
    print artist
    
    """
    mb.QueryWithArgs(MBQ_FindAlbumByName, [artist, album])
    print mb.GetResultRDF()
    numAlbums = mb.GetResultInt(MBE_GetNumAlbums)
    if numAlbums < 1:
        print "No albums found."
    for ii in range(1, numAlbums+1):
        mb.Select(MBS_Rewind)  
        mb.Select1(MBS_SelectAlbum, ii)  
        albumlist.append(mb.GetResultData(MBE_AlbumGetAlbumName))
    album = difflib.get_close_matches(album, albumlist, 1)[0]
    """

    mb.QueryWithArgs(MBQ_FindTrackByName, [artist, '', track])
    print mb.GetResultRDF()

if __name__ == '__main__':
    main()
