#!/usr/bin/env python

import sys
import musicbrainz
from musicbrainz.queries import *
import difflib

def main():
    mb = musicbrainz.mb()
    mb.SetServer('musicbrainz.org', 80)
    mb.UseUTF8(0)
    mb.SetDepth(2)

    ret = mb.QueryWithArgs(MBQ_FindArtistByName, [sys.argv[1]])
    if not ret:
        error = mb.GetQueryError()
        print "Query failed: %s" % error

    # Check to see how many items were returned from the server
    numArtists = mb.GetResultInt(MBE_GetNumArtists)
    if numArtists < 1:
        print "No artists found."
    
    print "Found %d artists." % numArtists

    for ii in range(1, numArtists+1):
        # Start at the top of the query and work our way down
        mb.Select(MBS_Rewind)  

        # Select the ith artist
        mb.Select1(MBS_SelectArtist, ii)  

        # Extract the artist name from the ith track
        data = mb.GetResultData(MBE_ArtistGetArtistName)
        print "    Artist: '%s'" % data

        # Extract the artist id from the ith track
        data = mb.GetResultData(MBE_ArtistGetArtistId)
        temp = mb.GetIDFromURL(data)
        print "  ArtistId: '%s'" % temp

        # Extract the number of albums 
        numAlbums = mb.GetResultInt(MBE_GetNumAlbums)
        print "Num Albums: %d" % numAlbums

        for jj in range(1, numAlbums+1):
            # Select the jth album in the album list
            mb.Select1(MBS_SelectAlbum, jj)  

            # Extract the album name 
            data = mb.GetResultData(MBE_AlbumGetAlbumName)
            print "     Album: '%s'" % data,
            
            data = mb.GetResultData(MBE_AlbumGetAlbumId)
            temp = mb.GetIDFromURL(data)
            print " (%s)" % temp
        
            # Back up one level and go back to the artist level 
            mb.Select(MBS_Back)  

        print ""

    
    
    



if __name__ == '__main__':
    main()
