#include <windows.h>
#include <winreg.h>
#include <stdio.h>
#include <stdlib.h>
#include "main.h"
//------------------------------------------------------------------------------
void ShowLastError( char* lpCaption )
{
	LPVOID lpMsgBuf;

	FormatMessage(
	    FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
	    NULL,
	    GetLastError(),
	    MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
	    (LPTSTR) &lpMsgBuf,
	    0,
	    NULL
	);

	MessageBox( NULL, (char*)lpMsgBuf, lpCaption, MB_OK|MB_ICONINFORMATION );
	LocalFree( lpMsgBuf );
}
//------------------------------------------------------------------------------
long GetCommandPid( char* pidfile )
{
	FILE *fp;
	char *buf;
	int length;
	long pid=0;

	fp = fopen( pidfile, "rb");
	
	if(fp)
	{
 		fseek(fp, 0L, SEEK_END);
 		length = ftell(fp);
 		fseek(fp, 0L, SEEK_SET);

		buf = (char*)malloc(length);
		fread( buf, 1, length, fp );
		fclose(fp);

		strtok( buf, "\n" );
		pid = strtol( buf, NULL, 10 );
		pid = abs(pid);

		free(buf);
	}
	return pid;
}
//------------------------------------------------------------------------------
static ConsoleRedirector ConsoleSignal;
void SignalCommand( long pid, const char* sig )
{
	if(pid)
	{	// Us a PID to kill program
		char buf[MAX_BUF_LEN];
		sprintf( buf, "%s %s %d", Prf.m_kill, sig, pid );
		RunProgram( buf, Prf.m_bindir );
	}
	else
	{	// "kill" program can handle everything
		RunProgram(Prf.m_kill, Prf.m_bindir);
	}
}
/*------------------------------------------------------------------------------
  Function		: strreplace
  Description	: replace ocuurence of "from" in "src" with "to"
  Date			: 04/11/02 18:15
------------------------------------------------------------------------------*/
char *strreplace( char *src, char* from, char *to )
{
	char *find, *prev;
	char *ret;
	size_t	len_from, len_to, len_ret, len_cp;

	ret = (char*)calloc( 1, sizeof(char) ); /* 1 byte for '\0' null terminator */

	len_ret = 1;
	len_from = strlen( from );
	len_to = strlen( to );

	find = src;		/* Current occurence */
	prev = find;	/* Previous occurence */

	do
	{
		find = strstr( find, from );
		if( find ) /* Ok replace token */
		{
			len_cp = find - prev;
			len_ret = len_ret + len_cp + len_to;
			ret = (char*)realloc(ret, len_ret);
			strncat( ret, prev, len_cp );
			strcat( ret, to );

			find += len_from; /* Move pointer after the token */
			prev = find;
		}
		else /* no more occurences , put rest of string */
		{
			len_cp = strlen( prev );
			len_ret += len_cp;
			ret = (char*)realloc(ret, len_ret);
			strcat( ret, prev );
		}
	}
	while( find );

	return(ret);
}
/*------------------------------------------------------------------------------
  Function		: strcasecmp
  Description	: Returns result of a case insensitive compare
  Date			: 
------------------------------------------------------------------------------*/
#ifdef NO_STRCASECMP
int strcasecmp(char *str1, char *str2)
{
	int n;
	do
		n = tolower(*str1) - tolower(*str2++);
	while(n==0 && *str1++);
	return n;
}
#endif
/*------------------------------------------------------------------------------
  Function		: IsWinNT
  Description	: Returns TRUE if running on NT
  Date			: 
------------------------------------------------------------------------------*/
BOOL IsWinNT()
{
  // get windows version
  DWORD WindowsVersion = GetVersion();
  DWORD WindowsMajorVersion = (DWORD)(LOBYTE(LOWORD(WindowsVersion)));
  DWORD WindowsMinorVersion = (DWORD)(HIBYTE(LOWORD(WindowsVersion)));

  // Running on WIN9x ?
  if (WindowsVersion >= 0x80000000) 
	return FALSE;

  // Running on NT
  return TRUE;
}
/*------------------------------------------------------------------------------
  Function		: StartProgram
  Description	: Starts a program in the background
  Date			: 
------------------------------------------------------------------------------*/
BOOL RunProgram(LPCSTR lpszCmd, LPCSTR lpszExecDir, PROCESS_INFORMATION *ppi)
{
	BOOL fResult;
	PROCESS_INFORMATION pi;
	STARTUPINFO si;
	::ZeroMemory(&si, sizeof(STARTUPINFO));
	si.cb = sizeof(STARTUPINFO);
	si.dwFlags = STARTF_USESHOWWINDOW;
	
	if(!ppi)
		ppi = &pi;

	// Use this if you want to show the console window of the child.

	PSECURITY_DESCRIPTOR lpSD = NULL;
	LPSECURITY_ATTRIBUTES lpSA = NULL;

	if (IsWinNT())
	{
		lpSD = (PSECURITY_DESCRIPTOR)::GlobalAlloc(GPTR, SECURITY_DESCRIPTOR_MIN_LENGTH);
		::InitializeSecurityDescriptor(lpSD, SECURITY_DESCRIPTOR_REVISION);
		::SetSecurityDescriptorDacl(lpSD, -1, 0, 0);

		lpSA = (LPSECURITY_ATTRIBUTES)::GlobalAlloc(GPTR, sizeof(SECURITY_ATTRIBUTES));
		lpSA->nLength = sizeof(SECURITY_ATTRIBUTES);
		lpSA->lpSecurityDescriptor = lpSD;
		lpSA->bInheritHandle = TRUE;
	}
	fResult = CreateProcess(NULL,	// app name		
				(char *)lpszCmd,	// command line
				lpSA,				// lpAccess
				NULL,				// Threads		
				TRUE,				// Inherit
				0,					// Create Flags
				NULL,				// Environment
				lpszExecDir,		// exec dir
				&si,
				ppi);

		// Cleanup memory allocation
	if (lpSA != NULL)
		::GlobalFree(lpSA);
	if (lpSD != NULL)
		::GlobalFree(lpSD);
	return fResult;
}
//------------------------------------------------------------------------------
