/* $PostgresPy: if/include/except.h,v 1.7 2004/06/15 03:52:43 flaw Exp $
 *
 * † Instrument:
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 * Description:
 *    A set of macros and definitions to help ease jmp'ing around.
 */
#ifndef EXCEPT_H
#define EXCEPT_H "except.h"
#ifdef __cplusplus
extern "C" {
#endif

#define sigjmp_copy(T,F)	memcpy(T,F, sizeof(sigjmp_buf))
#define sigjmp_cmp(THIS,THAT) (memcmp(THIS,THAT,sizeof(sigjmp_buf)) == 0)

#ifndef EXC_SAVEN
#	define EXC_SAVEN saven
#endif

#ifndef EXC_MAIN
#	define EXC_MAIN except_main;
#endif

#define _EXC_BUF(N)			exc_##N
#define _EXC_RV(N)			exc_rv_##N

#define _EXC_DECLARE(N,...)	__VA_ARGS__ sigjmp_buf _EXC_BUF(N); \
										__VA_ARGS__ int _EXC_RV(N) = 1

#define _EXC_SAVE(J,N)		sigjmp_copy(&_EXC_BUF(N), &J)
#define _EXC_RESTORE(J,N)	sigjmp_copy(&J, &_EXC_BUF(N))

#define _EXC_TRAP(J,N)		( (_EXC_RV(N) = sigsetjmp(J, 1)) != 0 )
#define _EXC_RAISE(J,N)		siglongjmp(J, _EXC_RV(N))

#define _EXC_SAVED(J,N)		sigjmp_cmp(J,_EXC_BUF(N))


#define EXC_BUF				_EXC_BUF(EXC_SAVEN)
#define EXC_RV					_EXC_RV(EXC_SAVEN)

#define EXC_DECLARE(...)	_EXC_DECLARE(EXC_SAVEN,__VA_ARGS__)

#define EXC_SAVE()			_EXC_SAVE(EXC_MAIN,EXC_SAVEN)
#define EXC_RESTORE()		_EXC_RESTORE(EXC_MAIN,EXC_SAVEN)

#define EXC_TRAP()			_EXC_TRAP(EXC_MAIN,EXC_SAVEN)
#define EXC_RAISE()			_EXC_RAISE(EXC_MAIN,EXC_SAVEN)

#define EXC_SAVED()			_EXC_SAVED(EXC_MAIN,EXC_SAVEN)

/*
 * EXCEPT - Simplify exception process.
 *
 * Usage: "EXCEPT( if (buffer) free(buffer); );"
 */
#define EXCEPT(Z)					\
do{EXC_SAVE();						\
	if (EXC_TRAP()) {				\
		EXC_RESTORE();				\
		Z								\
		EXC_RAISE(); } }while(0)

/*
 * This RETURN macro should be used instead of return() inside functions
 * that handle exceptions, notably after a EXC_SAVE(), so that the previous
 * exception is properly restored.
 */
#define RETURN(...) do { EXC_RESTORE(); return __VA_ARGS__; } while(0)

#ifdef __cplusplus
}
#endif
#endif   /* EXCEPT_H */
