/**************************************************************/
/*
 *  Ensemble, (Version 0.61)
 *  Copyright 1999 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */


/**************************************************************/
/**************************************************************/
/*
 *  Ensemble, (Version 0.40c)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */
/**************************************************************/
/* 
 * The Postgres GroupCommunicationTest 
 *
 * Author:  Bettina Kemme, Sept. 99
 *
 * NB: Access to the global struct is not protected with a mutex
 * (that could cause a deadlock). 
 *
 *  Created by: Win Bausch and Bettina Kemme
 *
 */
 #include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <time.h>
#include <errno.h>
#include "hot_sys.h"
#include "hot_error.h"
#include "hot_msg.h"
#include "hot_ens.h"
#include "hot_thread.h"
#include "replication/replication.h"
#include "replication/groupcomm.h"
#include "storage/ipc.h"
#include "utils/elog.h"


/*#define HOT_TEST_MAGIC 234324*/

/*#define MAXBUF 4000*/

static int HOT_TEST_MAGIC = 234324;
static int MAXBUF = 4000;
// DAR HACK
static int NANOSEC = 1000;

static struct {
  int nleave_act;
  int ncast_act;
  int nsend_act;

  int ncasts;
  int nsends;
  int nviews;
  int nexits;
  int nblocks;
  int nheartbeats;
  int njoins;
} stats;




static GroupCommStatisticsUnit msg_delay;
static GroupCommStatisticsUnit msg_copy1;
static GroupCommStatisticsUnit msg_copy2;
static GroupCommStatisticsUnit msg_write;
static GroupCommStatisticsUnit msg_read;		
static GroupCommStatisticsUnit network_delay;
/*
*	socket to the replication mgr (blocking)
*/
static int rmgrSock = -1;
static int rmgrSock_total = -1;
/*static int rmgrSock_local = -1;*/

/*
*	receive and send buffers
*/
static char rmgr_buf[4000];
static int  rmgr_msg_length;
static hot_sema_t buffer_sema ;
static char transis_buf[4000];

static void RmgrSockHandler(state *s);
static void receive_cast(hot_gctx_t gctx,void *env,hot_endpt_t *origin,hot_msg_t msg);
static void receive_send(hot_gctx_t gctx,void *env,hot_endpt_t *origin,hot_msg_t msg);
static void accepted_view(hot_gctx_t gctx,void *env,hot_view_state_t *view_state);
static void heartbeat(hot_gctx_t gctx,void *env,unsigned time);
static void exit_cb(hot_gctx_t gctx,void *env);
static void block(hot_gctx_t gctx,void *env);
static void action_cast(state *s);
static void check_stats(void);
static int readData(int sock, int len, char buf[]);
static int writeData(int sock, int len, char buf[]);
static void join(int thresh);




static void disconnect(state *s);
/******************************************************/

static void scheck(state *s,hot_gctx_t g) {
  assert(s) ;
  if (s->magic != 234324) {
    printf("gorp");
  }
  assert(s->magic == 234324) ;
  assert(s->gctx==g) ;
}

static void trace(char *s, ...) {
    /*va_list args;
    va_start(args, s);
    fprintf(stderr, "HOT_TEST:");
    vfprintf(stderr, s, args);
    fprintf(stderr, "\n");
    va_end(args);*/
}

static void check_stats(void) {
  static int nevents = 0 ;
  nevents++ ;
  if (nevents % 1000 == 0) {
    printf ("HOT_TEST:stats:c=%d s=%d v=%d e=%d b=%d h=%d j=%d (total=%d)\n", 
	    stats.ncasts,
	    stats.nsends,
	    stats.nviews,
	    stats.nexits,
	    stats.nblocks,
	    stats.nheartbeats,
	    stats.njoins,
	    (stats.ncasts+stats.nsends+stats.nviews+stats.nexits+stats.nblocks+stats.nheartbeats+stats.njoins)
	   ) ;
	 printf("msg delay:  %f \n", (double) (msg_delay.sum) / (double) (msg_delay.count * NANOSEC / 1000));
	 printf("net delay:  %f \n", (double) (network_delay.sum) / (double) (network_delay.count * NANOSEC / 1000));
printf("msg copy1:  %f \n", (double) (msg_copy1.sum) / (double) (msg_copy1.count * NANOSEC / 1000));
	 printf("msg copy2:  %f \n", (double) (msg_copy2.sum) / (double) (msg_copy2.count * NANOSEC / 1000));
	 printf("msg read:  %f \n", (double) (msg_read.sum) / (double) (msg_read.count * NANOSEC / 1000));
	 printf("msg write:  %f \n", (double) (msg_write.sum) / (double) (msg_write.count * NANOSEC / 1000));	 
  }
}

/********************** Actions *******************************************/


/* Send multicast messages->
 */
static void action_cast(state *s) {
  hot_err_t err;
  hot_msg_t msg;

  trace("action:  cast");

  
		StartGroupCommStats(msg_write);
  /* create a msg */
  msg = hot_msg_Create();

	err = hot_msg_Write(msg, rmgr_buf, rmgr_msg_length);
/*	hot_sema_Inc(buffer_sema);*/
    if (err != HOT_OK)
      hot_sys_Panic(hot_err_ErrString(err));
	
	StopGroupCommStats(msg_write);


	StartGroupCommStats(network_delay);	
    /* Actually send the msg */
    err = hot_ens_Cast(s->gctx, msg, NULL);
    if (err != HOT_OK)
      hot_sys_Panic(hot_err_ErrString(err));
      
      
	trace("action: casted");
/*	StopGroupCommStats(network_delay);*/
    
    /* free msg resources */
    err = hot_msg_Release(&msg);
    if (err != HOT_OK)
      hot_sys_Panic(hot_err_ErrString(err));
}

/********************** Callbacks *****************************************/

static void receive_cast(
        hot_gctx_t gctx,
	void *env,
	hot_endpt_t *origin, 
	hot_msg_t msg
) {
  state *s = (state*) env ;
  hot_err_t err;
  unsigned msg_size;
  rc_msg_t msg_type;

  scheck(s,gctx) ;
  trace("GotCast");
  
  /*elog(NOTICE,"total receive cast");*/
  
  StopGroupCommStats(network_delay);
  StartGroupCommStats(msg_read);
  hot_sema_Inc(buffer_sema);
    
  err  = hot_msg_Size(msg, &msg_size);
  if (err != HOT_OK)
    hot_sys_Panic(hot_err_ErrString(err));

  err = hot_msg_Read(msg, transis_buf, msg_size);
  if (err != HOT_OK)
    hot_sys_Panic(hot_err_ErrString(err));
  StopGroupCommStats(msg_read);
  
  /* bk: 2 sockets */
  msg_type = (rc_msg_t) ntohl (*((uint32 *)(transis_buf+BKND_ID_SIZE)));

  StartGroupCommStats(msg_copy2);  
  switch (msg_type)
  {
	case MSG_ABORT:
	case MSG_COMMIT:
	  elog(NOTICE,"there is a commit message in the total order group!");
	  /*if(writeData(rmgrSock_local, msg_size, transis_buf) <= 0)
	  {
		elog(NOTICE,"write data did somehow not work");
		proc_exit(400);
	  }*/
	  /*elog(NOTICE,"put on socket %d",rmgrSock_local);*/
	  break;
	case MSG_WRITESET:
	  /*elog(NOTICE,"send total to rmg");*/
	  if (writeData(rmgrSock_total, msg_size, transis_buf) <= 0)
	  {
		elog(NOTICE,"write data did somehow not work");
		proc_exit(400);
	  }
	  /*elog(NOTICE,"put on socket %d",rmgrSock_total);*/
	  break;
	default:
	  printf("different msg type %d\n", (int) msg_type);
	  break;
  }

  stats.ncasts++ ;
  check_stats() ;
  StopGroupCommStats(msg_copy2);
  StopGroupCommStats(msg_delay);
}

static void receive_send(
        hot_gctx_t gctx,
	void *env,
	hot_endpt_t *origin,
	hot_msg_t msg
) {}


/* We have accepted a new view.  The new view state is specified.
 */
static void accepted_view(
        hot_gctx_t gctx,
	void *env,
	hot_view_state_t *view_state
) {
  state *s = (state*) env ;
  int size, i ;
  static int started = 0;
  scheck(s,gctx) ;

  /* Release the old view.
   */
  if (s->vs.members != NULL) {
    free(s->vs.members) ;
  }
  s->vs = *view_state; 
  size = sizeof(s->vs.members[0])*s->vs.nmembers ;
  s->vs.members = (hot_endpt_t*) malloc(size) ;
  memcpy(s->vs.members,view_state->members,size) ;

  if (s->vs.rank == 0)
    printf("HOT_TEST:view (nmembers=%d, rank=%d)\n",s->vs.nmembers,s->vs.rank);


  printf("\tview_id = (%d,%s)\n", view_state->view_id.ltime,
	 view_state->view_id.coord.name);
  printf("\tversion = \"%s\"\n", view_state->version);
  printf("\tgroup_name = \"%s\"\n", view_state->group_name);
  printf("\tprotocol = \"%s\"\n", view_state->protocol);
  printf("\tmy_rank = %d\n", 	view_state->rank);
  printf("\tgroup daemon is %s\n", view_state->groupd ? "in use" : "not in use");
  printf("\tparameters = \"%s\"\n", view_state->params);
  printf("\txfer_view = %d\n", view_state->xfer_view);
  printf("\tprimary = %d\n", view_state->primary);
  
  for (i = 0; i < view_state->nmembers; i++)
    printf("%s\n", view_state->members[i].name);

  s->running = 1;

  if (started == 0)
    {
      started = 1;
      printf("i got into the view\n");
      hot_thread_Create((void*)RmgrSockHandler, s, 0);
    }

  stats.nviews++ ;
  check_stats() ;

}

/* A periodic heartbeat event has occurred.  The 'time' argument 
 * is an approximation of the current time.
 */
static void heartbeat(
        hot_gctx_t gctx,
	void *env,
	unsigned time
) {}

static void exit_cb(
        hot_gctx_t gctx,
        void *env
) {
 /* BUG: Modified here to reproduce a bug */

  printf("Got exit callback\n");
  exit(0);
}

static void block(
        hot_gctx_t gctx,
	void *env
) {}

static void join(int thresh) {
  hot_err_t err ;
  state *s ;
  char *outboard ;
  s = (state *) malloc(sizeof(*s)) ;
  memset(s,0,sizeof(*s)) ;
  
  
  s->thresh = thresh ;
  s->magic = 234324;
  s->jops.heartbeat_rate = 3000.0;
  s->sweep = 3000.0; 
/*  s->jops.argv = argv;*/
  s->next_sweep = 0 ;
  /* Can also set "DEERING" as transport here */
  if (getenv ("ENS_MODES"))
    strcpy(s->jops.transports, getenv("ENS_MODES"));
  else
  	strcpy(s->jops.transports, "DEERING");
  strcpy(s->jops.group_name, "HOT_total");

  /*strcpy(s->jops.properties, "Gmp:Sync:Heal:Switch:Frag:Suspect:Flow:Primary:Local");*/
  strcpy(s->jops.properties, "Total:Gmp:Sync:Heal:Switch:Frag:Suspect:Flow:Primary:Local");
  s->jops.use_properties = 1;
  strcpy(s->jops.params, "primary_quorum=15:int;suspect_max_idle=50:int;suspect_sweep=1.0:time");
  
  s->jops.groupd = 0;
  
  s->jops.conf.receive_cast = receive_cast;
  s->jops.conf.receive_send = receive_send;
  s->jops.conf.accepted_view = accepted_view;
  s->jops.conf.heartbeat = heartbeat;
  s->jops.conf.exit = exit_cb;
  s->jops.conf.block = block;
  s->jops.debug = 0 ;

  outboard = getenv("ENS_OUTBOARD_TYPE") ;
  if (!outboard) {
    outboard = "FORK" ;
  }
  strcpy(s->jops.outboard, outboard);
  
  s->jops.env = s;
  
  /* Join the group.
   */
  err = hot_ens_Join(&s->jops, &s->gctx);
  if (err != HOT_OK) {
    hot_sys_Panic(hot_err_ErrString(err));
  }


  stats.njoins++ ;
  check_stats() ;

  on_proc_exit(disconnect, (caddr_t) s);
}

int GroupCommMain_total(int socket, int socket_total) {
  hot_sema_t sema ;
  int thresh = 5 ;

  printf("hot test starting\n");
  trace("HOT_total: starting");
  
  /* Initialize state data.
   */
  srand(time(NULL));

#ifdef RMGR_DEBUG
  elog(NOTICE, "GroupComm pid %d", getpid());
#endif

  rmgrSock = socket;
  rmgrSock_total = socket_total;
  /*rmgrSock_local = socket_local;*/
  msg_delay.sum = 0.0;
  msg_delay.count = 0;
  network_delay.sum = 0.0;
  network_delay.count = 0;  
    msg_write.sum = 0.0;
  msg_write.count = 0;
  msg_read.sum = 0.0;
  msg_read.count = 0;  
    msg_copy1.sum = 0.0;
  msg_copy1.count = 0;
  msg_copy2.sum = 0.0;
  msg_copy2.count = 0;  
  
  join(thresh) ;

  printf("after join\n");
  hot_sema_Create(0,&sema) ;
  hot_sema_Dec(sema) ;

  return 0 ;
}

static void
RmgrSockHandler(state *s)
{
  int  datalen;
	rc_msg_t 	msg_type;

	hot_sema_Create(1,&buffer_sema) ;

  for(;;)
    {
		hot_sema_Dec(buffer_sema);
      /* read message from replication manager */
      /*
       *	read the message type
       */
     
	   		if(readData(rmgrSock, GROUPCOMM_HDR_SIZE, rmgr_buf) <= 0)
		{
		  elog(NOTICE," i read wrong data\n");
		  proc_exit(400);
		}
		StartGroupCommStats(msg_delay);
		StartGroupCommStats(msg_copy1);
		msg_type = (rc_msg_t) ntohl(*((long *) (rmgr_buf + 8)));
		datalen = ntohl(*((long *) (rmgr_buf + 12)));
      
      
		if(datalen != 0)
		{	
		  if(readData(rmgrSock, datalen, rmgr_buf + GROUPCOMM_HDR_SIZE) <= 0)
		  {
			  
			  printf("don't read good data\n");
			  proc_exit(400);
		  }
		}
		rmgr_msg_length = datalen + GROUPCOMM_HDR_SIZE;
		StopGroupCommStats(msg_copy1);
		/*hot_thread_Create((void*)action_cast, s, 0);  */
		action_cast(s);
	}
}


/*
*	readData
*
*	Reads a given number of bytes from a given (blocking) socket
*
*	param:
*		sock - the socket to read from
*		len - the number of bytes to read
*		buf - buffer to read them into
*	return:
*		void
*/

static	int
readData(int sock, int len, char buf[])
{
	int nread = 0; 
	
	for(;;)
	{
		if((nread = read(sock, buf , len)) <= 0)
		{
			if(nread < 0 && (errno == EINTR || errno == EAGAIN))
			{
				continue;
			}
			else
			{
				elog(DEBUG, "pg_transis: closing socket");
				close(sock);
			}
		}
		break;
	}
	return nread;
}

/*
*	writeData
*
*	Writes a given number of bytes to a given (blocking) socket
*
*	param:
*		sock - the socket to write to
*		len - the number of bytes to write
*		buf - buffer containing the data to write
*	return:
*		void
*/
static int
writeData(int sock, int len, char buf[])
{
	int nwritten = 0;
	
	for(;;)
	{
		if((nwritten = write(sock, buf, len)) <= 0)
		{
			if(nwritten < 0 && (errno == EINTR || errno == EAGAIN))
			{
				printf("in the continue loop\n");
				continue;
			}
			else
			{
				printf("in the closing socket thingi \n");
				elog(DEBUG, "pg_transis: closing socket");
				close(sock);
			}
		}
		break;
	}
	return nwritten;
}

/*
*	disconnect
*
*	Procedure to be registered as postgres exit callback. 
*	(on_proc_exit(...)) Removes all transis callbacks and leaves 
*	the rmgr group.
*
*	param:
*		dummy - dummy param needed by Postgres
*	return:
*		void
*/
static void
disconnect(state * s)
{
  hot_ens_Leave(s->gctx);
}
