/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSVideoColorPrimaries.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(VideoColorPrimaries enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("bt709"),
        MAKE_STATIC_STRING_IMPL("bt470bg"),
        MAKE_STATIC_STRING_IMPL("smpte170m"),
        MAKE_STATIC_STRING_IMPL("bt470m"),
        MAKE_STATIC_STRING_IMPL("smpte240m"),
        MAKE_STATIC_STRING_IMPL("film"),
        MAKE_STATIC_STRING_IMPL("bt2020"),
        MAKE_STATIC_STRING_IMPL("smpteSt4281"),
        MAKE_STATIC_STRING_IMPL("smpteRp431"),
        MAKE_STATIC_STRING_IMPL("smpte432"),
        MAKE_STATIC_STRING_IMPL("jedecP22Phosphors"),
        MAKE_STATIC_STRING_IMPL("unspecified"),
    };
    static_assert(static_cast<size_t>(VideoColorPrimaries::Bt709) == 0, "VideoColorPrimaries::Bt709 is not 0 as expected");
    static_assert(static_cast<size_t>(VideoColorPrimaries::Bt470bg) == 1, "VideoColorPrimaries::Bt470bg is not 1 as expected");
    static_assert(static_cast<size_t>(VideoColorPrimaries::Smpte170m) == 2, "VideoColorPrimaries::Smpte170m is not 2 as expected");
    static_assert(static_cast<size_t>(VideoColorPrimaries::Bt470m) == 3, "VideoColorPrimaries::Bt470m is not 3 as expected");
    static_assert(static_cast<size_t>(VideoColorPrimaries::Smpte240m) == 4, "VideoColorPrimaries::Smpte240m is not 4 as expected");
    static_assert(static_cast<size_t>(VideoColorPrimaries::Film) == 5, "VideoColorPrimaries::Film is not 5 as expected");
    static_assert(static_cast<size_t>(VideoColorPrimaries::Bt2020) == 6, "VideoColorPrimaries::Bt2020 is not 6 as expected");
    static_assert(static_cast<size_t>(VideoColorPrimaries::SmpteSt4281) == 7, "VideoColorPrimaries::SmpteSt4281 is not 7 as expected");
    static_assert(static_cast<size_t>(VideoColorPrimaries::SmpteRp431) == 8, "VideoColorPrimaries::SmpteRp431 is not 8 as expected");
    static_assert(static_cast<size_t>(VideoColorPrimaries::Smpte432) == 9, "VideoColorPrimaries::Smpte432 is not 9 as expected");
    static_assert(static_cast<size_t>(VideoColorPrimaries::JedecP22Phosphors) == 10, "VideoColorPrimaries::JedecP22Phosphors is not 10 as expected");
    static_assert(static_cast<size_t>(VideoColorPrimaries::Unspecified) == 11, "VideoColorPrimaries::Unspecified is not 11 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, VideoColorPrimaries enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<VideoColorPrimaries> parseEnumerationFromString<VideoColorPrimaries>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, VideoColorPrimaries> mappings[] = {
        { "bt2020", VideoColorPrimaries::Bt2020 },
        { "bt470bg", VideoColorPrimaries::Bt470bg },
        { "bt470m", VideoColorPrimaries::Bt470m },
        { "bt709", VideoColorPrimaries::Bt709 },
        { "film", VideoColorPrimaries::Film },
        { "jedecP22Phosphors", VideoColorPrimaries::JedecP22Phosphors },
        { "smpte170m", VideoColorPrimaries::Smpte170m },
        { "smpte240m", VideoColorPrimaries::Smpte240m },
        { "smpte432", VideoColorPrimaries::Smpte432 },
        { "smpteRp431", VideoColorPrimaries::SmpteRp431 },
        { "smpteSt4281", VideoColorPrimaries::SmpteSt4281 },
        { "unspecified", VideoColorPrimaries::Unspecified },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<VideoColorPrimaries> parseEnumeration<VideoColorPrimaries>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<VideoColorPrimaries>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<VideoColorPrimaries>()
{
    return "\"bt709\", \"bt470bg\", \"smpte170m\", \"bt470m\", \"smpte240m\", \"film\", \"bt2020\", \"smpteSt4281\", \"smpteRp431\", \"smpte432\", \"jedecP22Phosphors\", \"unspecified\""_s;
}

} // namespace WebCore

#endif // ENABLE(VIDEO)
