/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasGradient.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCanvasGradientPrototypeFunction_addColorStop);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCanvasGradientConstructor);

class JSCanvasGradientPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCanvasGradientPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCanvasGradientPrototype* ptr = new (NotNull, JSC::allocateCell<JSCanvasGradientPrototype>(vm)) JSCanvasGradientPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCanvasGradientPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCanvasGradientPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCanvasGradientPrototype, JSCanvasGradientPrototype::Base);

using JSCanvasGradientDOMConstructor = JSDOMConstructorNotConstructable<JSCanvasGradient>;

template<> const ClassInfo JSCanvasGradientDOMConstructor::s_info = { "CanvasGradient"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCanvasGradientDOMConstructor) };

template<> JSValue JSCanvasGradientDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCanvasGradientDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CanvasGradient"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCanvasGradient::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCanvasGradientPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCanvasGradientConstructor, 0 } },
    { "addColorStop"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCanvasGradientPrototypeFunction_addColorStop, 2 } },
};

const ClassInfo JSCanvasGradientPrototype::s_info = { "CanvasGradient"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCanvasGradientPrototype) };

void JSCanvasGradientPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCanvasGradient::info(), JSCanvasGradientPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCanvasGradient::s_info = { "CanvasGradient"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCanvasGradient) };

JSCanvasGradient::JSCanvasGradient(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CanvasGradient>&& impl)
    : JSDOMWrapper<CanvasGradient>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, CanvasGradient>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCanvasGradient::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCanvasGradientPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSCanvasGradientPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCanvasGradient::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCanvasGradient>(vm, globalObject);
}

JSValue JSCanvasGradient::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCanvasGradientDOMConstructor, DOMConstructorID::CanvasGradient>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSCanvasGradient::destroy(JSC::JSCell* cell)
{
    JSCanvasGradient* thisObject = static_cast<JSCanvasGradient*>(cell);
    thisObject->JSCanvasGradient::~JSCanvasGradient();
}

JSC_DEFINE_CUSTOM_GETTER(jsCanvasGradientConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCanvasGradientPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCanvasGradient::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsCanvasGradientPrototypeFunction_addColorStopBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasGradient>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto offsetConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(offsetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto colorConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(colorConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.addColorStop(*context, offsetConversionResult.releaseReturnValue(), colorConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCanvasGradientPrototypeFunction_addColorStop, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCanvasGradient>::call<jsCanvasGradientPrototypeFunction_addColorStopBody>(*lexicalGlobalObject, *callFrame, "addColorStop");
}

JSC::GCClient::IsoSubspace* JSCanvasGradient::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCanvasGradient, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCanvasGradient.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCanvasGradient = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCanvasGradient.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCanvasGradient = std::forward<decltype(space)>(space); }
    );
}

void JSCanvasGradient::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCanvasGradient*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSCanvasGradientOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSCanvasGradientOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCanvasGradient = static_cast<JSCanvasGradient*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsCanvasGradient->protectedWrapped().ptr(), jsCanvasGradient);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CanvasGradient@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14CanvasGradientE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, CanvasGradient>, void>> static inline void verifyVTable(CanvasGradient* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CanvasGradient@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14CanvasGradientE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CanvasGradient has subclasses. If CanvasGradient has subclasses that get passed
        // to toJS() we currently require CanvasGradient you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CanvasGradient>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CanvasGradient>(impl.ptr());
#endif
    return createWrapper<CanvasGradient>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CanvasGradient& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CanvasGradient* JSCanvasGradient::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCanvasGradient*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
