/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSVisibilityState.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(VisibilityState enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("hidden"),
        MAKE_STATIC_STRING_IMPL("visible"),
    };
    static_assert(static_cast<size_t>(VisibilityState::Hidden) == 0, "VisibilityState::Hidden is not 0 as expected");
    static_assert(static_cast<size_t>(VisibilityState::Visible) == 1, "VisibilityState::Visible is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, VisibilityState enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<VisibilityState> parseEnumerationFromString<VisibilityState>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, VisibilityState> mappings[] = {
        { "hidden", VisibilityState::Hidden },
        { "visible", VisibilityState::Visible },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<VisibilityState> parseEnumeration<VisibilityState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<VisibilityState>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<VisibilityState>()
{
    return "\"hidden\", \"visible\"";
}

} // namespace WebCore
