/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUImageCopyExternalImage.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertUnion.h"
#include "JSGPUOrigin2DDict.h"
#include "JSHTMLCanvasElement.h"
#include "JSImageBitmap.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <variant>


namespace WebCore {
using namespace JSC;

template<> GPUImageCopyExternalImage convertDictionary<GPUImageCopyExternalImage>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUImageCopyExternalImage result;
    JSValue flipYValue;
    if (isNullOrUndefined)
        flipYValue = jsUndefined();
    else {
        flipYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "flipY"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!flipYValue.isUndefined()) {
        result.flipY = convert<IDLBoolean>(lexicalGlobalObject, flipYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.flipY = false;
    JSValue originValue;
    if (isNullOrUndefined)
        originValue = jsUndefined();
    else {
        originValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "origin"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!originValue.isUndefined()) {
        result.origin = convert<IDLUnion<IDLSequence<IDLEnforceRangeAdaptor<IDLUnsignedLong>>, IDLDictionary<GPUOrigin2DDict>>>(lexicalGlobalObject, originValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sourceValue;
    if (isNullOrUndefined)
        sourceValue = jsUndefined();
    else {
        sourceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "source"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sourceValue.isUndefined()) {
        result.source = convert<IDLUnion<IDLInterface<ImageBitmap>, IDLInterface<HTMLCanvasElement>>>(lexicalGlobalObject, sourceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "source", "GPUImageCopyExternalImage", "(ImageBitmap or HTMLCanvasElement)");
        return { };
    }
    return result;
}

} // namespace WebCore
