/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXPathNSResolver.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "URL.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsXPathNSResolverPrototypeFunctionLookupNamespaceURI(JSC::ExecState*);

class JSXPathNSResolverPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSXPathNSResolverPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXPathNSResolverPrototype* ptr = new (NotNull, JSC::allocateCell<JSXPathNSResolverPrototype>(vm.heap)) JSXPathNSResolverPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXPathNSResolverPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSXPathNSResolverPrototypeTableValues[] =
{
    { "lookupNamespaceURI", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXPathNSResolverPrototypeFunctionLookupNamespaceURI), (intptr_t) (0) } },
};

const ClassInfo JSXPathNSResolverPrototype::s_info = { "XPathNSResolverPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXPathNSResolverPrototype) };

void JSXPathNSResolverPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXPathNSResolverPrototypeTableValues, *this);
}

const ClassInfo JSXPathNSResolver::s_info = { "XPathNSResolver", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXPathNSResolver) };

JSXPathNSResolver::JSXPathNSResolver(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XPathNSResolver>&& impl)
    : JSDOMWrapper<XPathNSResolver>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSXPathNSResolver::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSXPathNSResolverPrototype::create(vm, globalObject, JSXPathNSResolverPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSXPathNSResolver::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXPathNSResolver>(vm, globalObject);
}

void JSXPathNSResolver::destroy(JSC::JSCell* cell)
{
    JSXPathNSResolver* thisObject = static_cast<JSXPathNSResolver*>(cell);
    thisObject->JSXPathNSResolver::~JSXPathNSResolver();
}

EncodedJSValue JSC_HOST_CALL jsXPathNSResolverPrototypeFunctionLookupNamespaceURI(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXPathNSResolver*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XPathNSResolver", "lookupNamespaceURI");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXPathNSResolver::info());
    auto& impl = castedThis->wrapped();
    String prefix = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringOrNull(state, impl.lookupNamespaceURI(prefix));
    return JSValue::encode(result);
}

bool JSXPathNSResolverOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSXPathNSResolverOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXPathNSResolver = jsCast<JSXPathNSResolver*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXPathNSResolver->wrapped(), jsXPathNSResolver);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, XPathNSResolver* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSXPathNSResolver>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, XPathNSResolver* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSXPathNSResolver>(globalObject, impl))
        return result;
    return createNewWrapper<JSXPathNSResolver>(globalObject, impl);
}

XPathNSResolver* JSXPathNSResolver::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXPathNSResolver*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
