/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLRenderingContext.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsWebGLRenderingContextConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebGLRenderingContextConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGLRenderingContextPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebGLRenderingContextPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLRenderingContextPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLRenderingContextPrototype>(vm.heap)) JSWebGLRenderingContextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLRenderingContextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSWebGLRenderingContext> JSWebGLRenderingContextConstructor;

template<> JSValue JSWebGLRenderingContextConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLRenderingContextConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGLRenderingContext::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("WebGLRenderingContext"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSWebGLRenderingContextConstructor::s_info = { "WebGLRenderingContext", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLRenderingContextConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGLRenderingContextPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLRenderingContextConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLRenderingContextConstructor) } },
};

const ClassInfo JSWebGLRenderingContextPrototype::s_info = { "WebGLRenderingContextPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLRenderingContextPrototype) };

void JSWebGLRenderingContextPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLRenderingContextPrototypeTableValues, *this);
}

const ClassInfo JSWebGLRenderingContext::s_info = { "WebGLRenderingContext", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLRenderingContext) };

JSWebGLRenderingContext::JSWebGLRenderingContext(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLRenderingContext>&& impl)
    : JSWebGLRenderingContextBase(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebGLRenderingContext::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebGLRenderingContextPrototype::create(vm, globalObject, JSWebGLRenderingContextPrototype::createStructure(vm, globalObject, JSWebGLRenderingContextBase::getPrototype(vm, globalObject)));
}

JSObject* JSWebGLRenderingContext::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLRenderingContext>(vm, globalObject);
}

EncodedJSValue jsWebGLRenderingContextConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSWebGLRenderingContextPrototype* domObject = jsDynamicCast<JSWebGLRenderingContextPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSWebGLRenderingContext::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSWebGLRenderingContextConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWebGLRenderingContextPrototype* domObject = jsDynamicCast<JSWebGLRenderingContextPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSWebGLRenderingContext::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLRenderingContextConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGLRenderingContext::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSWebGLRenderingContext*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}


}

#endif // ENABLE(WEBGL)
