/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLDebugRendererInfo.h"

#include "JSDOMBinding.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

class JSWebGLDebugRendererInfoPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebGLDebugRendererInfoPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLDebugRendererInfoPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLDebugRendererInfoPrototype>(vm.heap)) JSWebGLDebugRendererInfoPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLDebugRendererInfoPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSWebGLDebugRendererInfoPrototypeTableValues[] =
{
    { "UNMASKED_VENDOR_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x9245) } },
    { "UNMASKED_RENDERER_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x9246) } },
};

const ClassInfo JSWebGLDebugRendererInfoPrototype::s_info = { "WebGLDebugRendererInfoPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLDebugRendererInfoPrototype) };

void JSWebGLDebugRendererInfoPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLDebugRendererInfoPrototypeTableValues, *this);
}

const ClassInfo JSWebGLDebugRendererInfo::s_info = { "WebGLDebugRendererInfo", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLDebugRendererInfo) };

JSWebGLDebugRendererInfo::JSWebGLDebugRendererInfo(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLDebugRendererInfo>&& impl)
    : JSDOMWrapper<WebGLDebugRendererInfo>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebGLDebugRendererInfo::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebGLDebugRendererInfoPrototype::create(vm, globalObject, JSWebGLDebugRendererInfoPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWebGLDebugRendererInfo::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLDebugRendererInfo>(vm, globalObject);
}

void JSWebGLDebugRendererInfo::destroy(JSC::JSCell* cell)
{
    JSWebGLDebugRendererInfo* thisObject = static_cast<JSWebGLDebugRendererInfo*>(cell);
    thisObject->JSWebGLDebugRendererInfo::~JSWebGLDebugRendererInfo();
}

bool JSWebGLDebugRendererInfoOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsWebGLDebugRendererInfo = jsCast<JSWebGLDebugRendererInfo*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsWebGLDebugRendererInfo->wrapped().context());
    return visitor.containsOpaqueRoot(root);
}

void JSWebGLDebugRendererInfoOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLDebugRendererInfo = jsCast<JSWebGLDebugRendererInfo*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLDebugRendererInfo->wrapped(), jsWebGLDebugRendererInfo);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLDebugRendererInfo@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22WebGLDebugRendererInfoE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLDebugRendererInfo* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebGLDebugRendererInfo>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLDebugRendererInfo* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLDebugRendererInfo>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebGLDebugRendererInfo@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore22WebGLDebugRendererInfoE[2];
#if COMPILER(CLANG)
    // If this fails WebGLDebugRendererInfo does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebGLDebugRendererInfo), WebGLDebugRendererInfo_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebGLDebugRendererInfo has subclasses. If WebGLDebugRendererInfo has subclasses that get passed
    // to toJS() we currently require WebGLDebugRendererInfo you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSWebGLDebugRendererInfo>(globalObject, impl);
}

WebGLDebugRendererInfo* JSWebGLDebugRendererInfo::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLDebugRendererInfo*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
