/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLCompressedTextureATC.h"

#include "JSDOMBinding.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

class JSWebGLCompressedTextureATCPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebGLCompressedTextureATCPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLCompressedTextureATCPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLCompressedTextureATCPrototype>(vm.heap)) JSWebGLCompressedTextureATCPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLCompressedTextureATCPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSWebGLCompressedTextureATCPrototypeTableValues[] =
{
    { "COMPRESSED_RGB_ATC_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8C92) } },
    { "COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x8C93) } },
    { "COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x87EE) } },
};

const ClassInfo JSWebGLCompressedTextureATCPrototype::s_info = { "WebGLCompressedTextureATCPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLCompressedTextureATCPrototype) };

void JSWebGLCompressedTextureATCPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLCompressedTextureATCPrototypeTableValues, *this);
}

const ClassInfo JSWebGLCompressedTextureATC::s_info = { "WebGLCompressedTextureATC", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLCompressedTextureATC) };

JSWebGLCompressedTextureATC::JSWebGLCompressedTextureATC(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLCompressedTextureATC>&& impl)
    : JSDOMWrapper<WebGLCompressedTextureATC>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebGLCompressedTextureATC::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebGLCompressedTextureATCPrototype::create(vm, globalObject, JSWebGLCompressedTextureATCPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWebGLCompressedTextureATC::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLCompressedTextureATC>(vm, globalObject);
}

void JSWebGLCompressedTextureATC::destroy(JSC::JSCell* cell)
{
    JSWebGLCompressedTextureATC* thisObject = static_cast<JSWebGLCompressedTextureATC*>(cell);
    thisObject->JSWebGLCompressedTextureATC::~JSWebGLCompressedTextureATC();
}

bool JSWebGLCompressedTextureATCOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsWebGLCompressedTextureATC = jsCast<JSWebGLCompressedTextureATC*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsWebGLCompressedTextureATC->wrapped().context());
    return visitor.containsOpaqueRoot(root);
}

void JSWebGLCompressedTextureATCOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLCompressedTextureATC = jsCast<JSWebGLCompressedTextureATC*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLCompressedTextureATC->wrapped(), jsWebGLCompressedTextureATC);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLCompressedTextureATC@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25WebGLCompressedTextureATCE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLCompressedTextureATC* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebGLCompressedTextureATC>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLCompressedTextureATC* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLCompressedTextureATC>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebGLCompressedTextureATC@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore25WebGLCompressedTextureATCE[2];
#if COMPILER(CLANG)
    // If this fails WebGLCompressedTextureATC does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebGLCompressedTextureATC), WebGLCompressedTextureATC_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebGLCompressedTextureATC has subclasses. If WebGLCompressedTextureATC has subclasses that get passed
    // to toJS() we currently require WebGLCompressedTextureATC you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSWebGLCompressedTextureATC>(globalObject, impl);
}

WebGLCompressedTextureATC* JSWebGLCompressedTextureATC::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLCompressedTextureATC*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
