/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTextMetrics.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsTextMetricsWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextMetricsConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSTextMetricsConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSTextMetricsPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSTextMetricsPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTextMetricsPrototype* ptr = new (NotNull, JSC::allocateCell<JSTextMetricsPrototype>(vm.heap)) JSTextMetricsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTextMetricsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSTextMetrics> JSTextMetricsConstructor;

template<> JSValue JSTextMetricsConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTextMetricsConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTextMetrics::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("TextMetrics"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSTextMetricsConstructor::s_info = { "TextMetrics", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTextMetricsConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTextMetricsPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextMetricsConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTextMetricsConstructor) } },
    { "width", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextMetricsWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSTextMetricsPrototype::s_info = { "TextMetricsPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTextMetricsPrototype) };

void JSTextMetricsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTextMetricsPrototypeTableValues, *this);
}

const ClassInfo JSTextMetrics::s_info = { "TextMetrics", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTextMetrics) };

JSTextMetrics::JSTextMetrics(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TextMetrics>&& impl)
    : JSDOMWrapper<TextMetrics>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSTextMetrics::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSTextMetricsPrototype::create(vm, globalObject, JSTextMetricsPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSTextMetrics::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTextMetrics>(vm, globalObject);
}

void JSTextMetrics::destroy(JSC::JSCell* cell)
{
    JSTextMetrics* thisObject = static_cast<JSTextMetrics*>(cell);
    thisObject->JSTextMetrics::~JSTextMetrics();
}

EncodedJSValue jsTextMetricsWidth(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTextMetrics*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TextMetrics", "width");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.width());
    return JSValue::encode(result);
}


EncodedJSValue jsTextMetricsConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSTextMetricsPrototype* domObject = jsDynamicCast<JSTextMetricsPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSTextMetrics::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSTextMetricsConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSTextMetricsPrototype* domObject = jsDynamicCast<JSTextMetricsPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSTextMetrics::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextMetricsConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSTextMetricsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSTextMetricsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTextMetrics = jsCast<JSTextMetrics*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTextMetrics->wrapped(), jsTextMetrics);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, TextMetrics* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSTextMetrics>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, TextMetrics* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSTextMetrics>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to TextMetrics.
    COMPILE_ASSERT(!__is_polymorphic(TextMetrics), TextMetrics_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSTextMetrics>(globalObject, impl);
}

TextMetrics* JSTextMetrics::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTextMetrics*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
