/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSText.h"

#include "Document.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSText.h"
#include "Text.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsTextPrototypeFunctionSplitText(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsTextPrototypeFunctionReplaceWholeText(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsTextWholeText(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSTextConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSTextPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSTextPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTextPrototype* ptr = new (NotNull, JSC::allocateCell<JSTextPrototype>(vm.heap)) JSTextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSText> JSTextConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSTextConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSTextConstructor*>(state->callee());
    String data = state->argument(0).isUndefined() ? String() : state->uncheckedArgument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "Text");
    auto& document = downcast<Document>(*context);
    RefPtr<Text> object = Text::create(document, data);
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSTextConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCharacterData::getConstructor(vm, &globalObject);
}

template<> void JSTextConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSText::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Text"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSTextConstructor::s_info = { "Text", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTextConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTextPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTextConstructor) } },
    { "wholeText", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextWholeText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "splitText", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTextPrototypeFunctionSplitText), (intptr_t) (1) } },
    { "replaceWholeText", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTextPrototypeFunctionReplaceWholeText), (intptr_t) (0) } },
};

const ClassInfo JSTextPrototype::s_info = { "TextPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTextPrototype) };

void JSTextPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTextPrototypeTableValues, *this);
}

const ClassInfo JSText::s_info = { "Text", &Base::s_info, 0, CREATE_METHOD_TABLE(JSText) };

JSText::JSText(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Text>&& impl)
    : JSCharacterData(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSText::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSTextPrototype::create(vm, globalObject, JSTextPrototype::createStructure(vm, globalObject, JSCharacterData::getPrototype(vm, globalObject)));
}

JSObject* JSText::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSText>(vm, globalObject);
}

EncodedJSValue jsTextWholeText(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSText*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Text", "wholeText");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.wholeText());
    return JSValue::encode(result);
}


EncodedJSValue jsTextConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSTextPrototype* domObject = jsDynamicCast<JSTextPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSText::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSTextConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSTextPrototype* domObject = jsDynamicCast<JSTextPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSText::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTextPrototypeFunctionSplitText(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSText*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Text", "splitText");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSText::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    unsigned offset = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.splitText(offset, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTextPrototypeFunctionReplaceWholeText(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSText*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Text", "replaceWholeText");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSText::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String content = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.replaceWholeText(content, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

void JSText::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSText*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}
